/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.webmvc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PathPatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

public class RequestMappingHelper {
    public static Map<RequestMappingInfo, HandlerMethod> listAllMapping(ApplicationContext context) {
        Map handlers = context.getBeansOfType(RequestMappingInfoHandlerMapping.class, true, false);
        LinkedHashMap<RequestMappingInfo, HandlerMethod> mapping = new LinkedHashMap<RequestMappingInfo, HandlerMethod>();
        for (RequestMappingInfoHandlerMapping hm : handlers.values()) {
            mapping.putAll(hm.getHandlerMethods());
        }
        return mapping;
    }

    public static void dealAllMapping(ApplicationContext context, BiConsumer<RequestMappingInfo, HandlerMethod> consumer) {
        Map<RequestMappingInfo, HandlerMethod> mapping = RequestMappingHelper.listAllMapping(context);
        for (Map.Entry<RequestMappingInfo, HandlerMethod> entry : mapping.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    @NotNull
    public static List<Info> infoAllMapping(ApplicationContext context) {
        Map<RequestMappingInfo, HandlerMethod> mappings = RequestMappingHelper.listAllMapping(context);
        ArrayList<Info> result = new ArrayList<Info>(mappings.size() * 3 / 2);
        for (Map.Entry<RequestMappingInfo, HandlerMethod> entry : mappings.entrySet()) {
            PathPatternsRequestCondition ppc;
            RequestMappingInfo key = entry.getKey();
            HandlerMethod value = entry.getValue();
            Method method = value.getMethod();
            String javaClass = method.getDeclaringClass().getName();
            String javaMethod = method.getName();
            String httpMethod = key.getMethodsCondition().getMethods().stream().map(Enum::name).collect(Collectors.joining(","));
            PatternsRequestCondition prc = key.getPatternsCondition();
            if (prc != null) {
                for (String url : prc.getPatterns()) {
                    result.add(new Info(url, httpMethod, javaClass, javaMethod));
                }
            }
            if ((ppc = key.getPathPatternsCondition()) == null) continue;
            for (String url : ppc.getPatternValues()) {
                result.add(new Info(url, httpMethod, javaClass, javaMethod));
            }
        }
        return result;
    }

    public static class Info {
        private final String url;
        private final String httpMethod;
        private final String javaClass;
        private final String javaMethod;

        public boolean hasMethod(RequestMethod method) {
            if (method == null || this.httpMethod.isEmpty()) {
                return true;
            }
            return this.httpMethod.contains(method.name());
        }

        public String toJson() {
            return "{url:\"" + this.url.replaceAll("\"", "\\\"") + "\",method=\"" + this.httpMethod + "\",java=\"" + this.javaClass + "#" + this.javaMethod + "\"}";
        }

        @Generated
        public Info(String url, String httpMethod, String javaClass, String javaMethod) {
            this.url = url;
            this.httpMethod = httpMethod;
            this.javaClass = javaClass;
            this.javaMethod = javaMethod;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public String getHttpMethod() {
            return this.httpMethod;
        }

        @Generated
        public String getJavaClass() {
            return this.javaClass;
        }

        @Generated
        public String getJavaMethod() {
            return this.javaMethod;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Info)) {
                return false;
            }
            Info other = (Info)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$httpMethod = this.getHttpMethod();
            String other$httpMethod = other.getHttpMethod();
            if (this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod)) {
                return false;
            }
            String this$javaClass = this.getJavaClass();
            String other$javaClass = other.getJavaClass();
            if (this$javaClass == null ? other$javaClass != null : !this$javaClass.equals(other$javaClass)) {
                return false;
            }
            String this$javaMethod = this.getJavaMethod();
            String other$javaMethod = other.getJavaMethod();
            return !(this$javaMethod == null ? other$javaMethod != null : !this$javaMethod.equals(other$javaMethod));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Info;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $httpMethod = this.getHttpMethod();
            result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
            String $javaClass = this.getJavaClass();
            result = result * 59 + ($javaClass == null ? 43 : $javaClass.hashCode());
            String $javaMethod = this.getJavaMethod();
            result = result * 59 + ($javaMethod == null ? 43 : $javaMethod.hashCode());
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "RequestMappingHelper.Info(url=" + this.getUrl() + ", httpMethod=" + this.getHttpMethod() + ", javaClass=" + this.getJavaClass() + ", javaMethod=" + this.getJavaMethod() + ")";
        }
    }
}

