/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.servlet.resolver;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class WingsRemoteResolver {
    private final Set<String> innerIp = new LinkedHashSet<String>();
    private final Set<String> ipHeader = new LinkedHashSet<String>();
    private final Set<String> agentHeader = new LinkedHashSet<String>();

    public void addInnerIp(Collection<String> keys) {
        this.innerIp.addAll(keys);
    }

    public void addAgentHeader(Collection<String> keys) {
        this.agentHeader.addAll(keys);
    }

    public void addIpHeader(Collection<String> keys) {
        this.ipHeader.addAll(keys);
    }

    @NotNull
    public String resolveRemoteKey(HttpServletRequest request, String ... header) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.resolveRemoteIp(request));
        sb.append('|');
        sb.append(this.resolveRemoteIp(request));
        for (String h : header) {
            sb.append('|');
            sb.append(request.getHeader(h));
        }
        return sb.toString();
    }

    @NotNull
    public String resolveRemoteIp(HttpServletRequest request) {
        String s;
        Object atr = request.getAttribute("WINGS.ATTR.REMOTE_IP");
        if (atr instanceof String) {
            String ip = (String)atr;
            return ip;
        }
        String ip = null;
        Iterator<String> iterator = this.ipHeader.iterator();
        while (iterator.hasNext() && !this.isOuterAddr(ip = this.trimComma(request.getHeader(s = iterator.next())))) {
        }
        if (ip == null) {
            ip = request.getRemoteAddr();
        }
        request.setAttribute("WINGS.ATTR.REMOTE_IP", (Object)ip);
        return ip;
    }

    private String trimComma(String s) {
        if (s == null) {
            return null;
        }
        int p = s.indexOf(44);
        return p > 0 ? s.substring(0, p) : s;
    }

    private boolean isOuterAddr(String ip) {
        if (ip == null) {
            return false;
        }
        for (String s : this.innerIp) {
            if (!ip.startsWith(s)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String resolveAgentInfo(HttpServletRequest request) {
        Object atr = request.getAttribute("WINGS.ATTR.AGENT_INFO");
        if (atr instanceof String) {
            String ai = (String)atr;
            return ai;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : this.agentHeader) {
            String h = request.getHeader(s);
            if (h == null) continue;
            sb.append(h).append(";");
        }
        String info = sb.toString();
        request.setAttribute("WINGS.ATTR.AGENT_INFO", (Object)info);
        return info;
    }

    @Generated
    public Set<String> getInnerIp() {
        return this.innerIp;
    }

    @Generated
    public Set<String> getIpHeader() {
        return this.ipHeader;
    }

    @Generated
    public Set<String> getAgentHeader() {
        return this.agentHeader;
    }
}

