/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springdoc.core.annotations.ParameterObject;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pro.fessional.mirana.page.PageQuery;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.silencer.spring.help.CommonPropHelper;
import pro.fessional.wings.slardar.spring.prop.SlardarSwaggerProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled(abs="wings.enabled.slardar.swagger")
@ConditionalOnClass(value={OpenAPI.class})
public class SlardarSwaggerConfiguration {
    private static final Log log = LogFactory.getLog(SlardarSwaggerConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public OpenApiCustomizer slardarOpenApiCustomizer(SlardarSwaggerProp slardarSwaggerProp) {
        log.info((Object)"SlardarWebmvc spring-bean slardarOpenApiCustomizer");
        if (slardarSwaggerProp.isFlatPagequery()) {
            log.info((Object)"SlardarWebmvc spring-bean slardarOpenApiCustomizer flat PageQuery");
            SpringDocUtils.getConfig().replaceParameterObjectWithClass(PageQuery.class, FlatPageQuery.class);
        }
        return openApi -> {
            Info info = openApi.getInfo();
            if (slardarSwaggerProp.getTitle() != null) {
                info.setTitle(slardarSwaggerProp.getTitle());
            }
            if (slardarSwaggerProp.getDescription() != null) {
                info.setDescription(slardarSwaggerProp.getDescription());
            }
            if (slardarSwaggerProp.getVersion() != null) {
                info.setVersion(slardarSwaggerProp.getVersion());
            }
            Map<String, io.swagger.v3.oas.models.parameters.Parameter> params = slardarSwaggerProp.toComPara();
            LinkedHashMap accepts = CommonPropHelper.onlyValue(slardarSwaggerProp.getAccept());
            if (params.isEmpty() && accepts.isEmpty()) {
                return;
            }
            openApi.getPaths().values().stream().flatMap(pathItem -> pathItem.readOperations().stream()).forEach(operation -> this.enhanceOperation(params, accepts, (Operation)operation));
        };
    }

    private void enhanceOperation(Map<String, io.swagger.v3.oas.models.parameters.Parameter> params, Map<String, String> accepts, Operation operation) {
        for (io.swagger.v3.oas.models.parameters.Parameter param : params.values()) {
            operation.addParametersItem(param);
        }
        if (accepts.isEmpty()) {
            return;
        }
        for (ApiResponse res : operation.getResponses().values()) {
            Content ctt = res.getContent();
            if (ctt == null || ctt.isEmpty()) continue;
            MediaType dmt = (MediaType)ctt.values().iterator().next();
            Iterator<Map.Entry<String, String>> iterator = accepts.entrySet().iterator();
            while (iterator.hasNext()) {
                String cp;
                MediaType mt;
                Map.Entry<String, String> apt;
                ctt.addMediaType(apt.getKey(), (mt = (MediaType)ctt.get((Object)(cp = (apt = iterator.next()).getValue()))) == null ? dmt : mt);
            }
        }
    }

    @ParameterObject
    public static class FlatPageQuery {
        @Parameter(description="1-based page number, name-alias=[${wings.slardar.pagequery.page-alias}] by 'wings.slardar.pagequery.page-alias', default=${wings.slardar.pagequery.page}", schema=@Schema(type="integer", example="1"))
        private int page;
        @Parameter(description="1-based size of page, name-alias=[${wings.slardar.pagequery.size-alias}] by 'wings.slardar.pagequery.size-alias', default=${wings.slardar.pagequery.size}", schema=@Schema(type="integer", example="20"))
        private int size;
        @Parameter(description="comma-separated string, name-alias=[${wings.slardar.pagequery.sort-alias}] by 'wings.slardar.pagequery.sort-alias' eg. 'k1,-k2' means 'order by k1 asc, k2 desc', '-' means 'desc'", schema=@Schema(type="string"))
        private String sort;

        @Generated
        public FlatPageQuery() {
        }

        @Generated
        public int getPage() {
            return this.page;
        }

        @Generated
        public int getSize() {
            return this.size;
        }

        @Generated
        public String getSort() {
            return this.sort;
        }

        @Generated
        public void setPage(int page) {
            this.page = page;
        }

        @Generated
        public void setSize(int size) {
            this.size = size;
        }

        @Generated
        public void setSort(String sort) {
            this.sort = sort;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FlatPageQuery)) {
                return false;
            }
            FlatPageQuery other = (FlatPageQuery)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPage() != other.getPage()) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            String this$sort = this.getSort();
            String other$sort = other.getSort();
            return !(this$sort == null ? other$sort != null : !this$sort.equals(other$sort));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof FlatPageQuery;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPage();
            result = result * 59 + this.getSize();
            String $sort = this.getSort();
            result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "SlardarSwaggerConfiguration.FlatPageQuery(page=" + this.getPage() + ", size=" + this.getSize() + ", sort=" + this.getSort() + ")";
        }
    }
}

