/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.i18n.TimeZoneAwareLocaleContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.context.SecurityContextUtil;
import pro.fessional.wings.slardar.context.TerminalAttribute;
import pro.fessional.wings.slardar.context.TerminalInterceptor;
import pro.fessional.wings.slardar.context.TerminalSecurityAttribute;
import pro.fessional.wings.slardar.security.WingsUserDetails;
import pro.fessional.wings.slardar.servlet.resolver.WingsLocaleResolver;
import pro.fessional.wings.slardar.servlet.resolver.WingsRemoteResolver;
import pro.fessional.wings.slardar.spring.prop.SlardarTerminalProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled(abs="wings.enabled.slardar.terminal")
public class SlardarTerminalConfiguration {
    private final Log log = LogFactory.getLog(SlardarTerminalConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public TerminalInterceptor.TerminalBuilder remoteTerminalBuilder(WingsRemoteResolver resolver) {
        this.log.info((Object)"SlardarWebmvc spring-bean remoteTerminalBuilder");
        return (builder, request) -> builder.terminal(TerminalAttribute.TerminalAddr, (Object)resolver.resolveRemoteIp(request)).terminal(TerminalAttribute.TerminalAgent, (Object)resolver.resolveAgentInfo(request));
    }

    @Bean
    @ConditionalWingsEnabled
    public TerminalInterceptor.TerminalBuilder securityTerminalBuilder(WingsLocaleResolver resolver) {
        this.log.info((Object)"SlardarWebmvc spring-bean securityTerminalBuilder");
        return (builder, request) -> {
            Authentication authn = SecurityContextUtil.getAuthentication(false);
            WingsUserDetails details = SecurityContextUtil.getUserDetails(authn);
            if (details == null) {
                Long userId = (Long)request.getAttribute("WINGS.ATTR.USER_ID");
                TimeZoneAwareLocaleContext locale = resolver.resolveI18nContext(request, userId);
                builder.locale(locale.getLocale()).timeZone(locale.getTimeZone()).userOrGuest(userId);
            } else {
                builder.locale(details.getLocale()).timeZone(details.getZoneId()).user(details.getUserId()).authType(details.getAuthType()).username(details.getUsername()).authPerm((Collection)details.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet())).terminal(TerminalSecurityAttribute.UserDetails, (Object)details).terminal(TerminalSecurityAttribute.AuthDetails, (Object)SecurityContextUtil.getAuthDetails(authn));
            }
        };
    }

    @Bean
    @ConditionalWingsEnabled
    public TerminalInterceptor terminalInterceptor(SlardarTerminalProp prop, ObjectProvider<TerminalInterceptor.TerminalBuilder> builders, ObjectProvider<TerminalInterceptor.TerminalLogger> loggers) {
        Map<String, String> ic;
        this.log.info((Object)"SlardarWebmvc spring-bean terminalInterceptor");
        TerminalInterceptor bean = new TerminalInterceptor();
        builders.orderedStream().forEach(bean::addTerminalBuilder);
        loggers.orderedStream().forEach(bean::addTerminalLogger);
        Map<String, String> ex = prop.getExcludePatterns();
        if (!ex.isEmpty()) {
            ArrayList<String> vs = new ArrayList<String>(ex.values());
            this.log.info((Object)("SlardarWebmvc spring-conf terminalInterceptor ExcludePatterns=" + String.valueOf(vs)));
            bean.setExcludePatterns(vs);
        }
        if (!(ic = prop.getIncludePatterns()).isEmpty()) {
            ArrayList<String> vs = new ArrayList<String>(ic.values());
            this.log.info((Object)("SlardarWebmvc spring-conf terminalInterceptor IncludePatterns=" + String.valueOf(vs)));
            bean.setExcludePatterns(vs);
        }
        return bean;
    }
}

