/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.servlet.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.cache2k.Cache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.filter.OrderedFilter;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.slardar.cache.cache2k.WingsCache2k;
import pro.fessional.wings.slardar.servlet.resolver.WingsRemoteResolver;

@Deprecated
public class WingsOverloadFilter
implements OrderedFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WingsOverloadFilter.class);
    private int order = -29996000;
    private final AtomicInteger requestCapacity = new AtomicInteger(0);
    private final AtomicInteger requestProcess = new AtomicInteger(0);
    private final AtomicLong lastInfoStat = new AtomicLong(0L);
    private final int costStep = 20;
    private final AtomicLong[] responseCost;
    private final AtomicLong responseTotal = new AtomicLong(0L);
    private final FallBack fallBack;
    private final Config config;
    private final WingsRemoteResolver terminalResolver;
    private final Cache<String, CalmDown> spiderCache;
    private final Cache<String, Long> lastWarnSlow;

    public WingsOverloadFilter(FallBack fallBack, Config config, WingsRemoteResolver terminalResolver) {
        this.fallBack = fallBack;
        this.config = config;
        this.terminalResolver = terminalResolver;
        if (config.requestInterval <= 0L || config.requestCalmdown <= 0) {
            this.spiderCache = null;
        } else {
            int capacity = this.initCapacity(config);
            this.requestCapacity.set(capacity);
            Duration ttl = Duration.ofMillis(config.requestInterval * (long)config.requestCalmdown * 2L);
            this.spiderCache = WingsCache2k.builder(WingsOverloadFilter.class, (String)"spiderCache", (int)capacity, (Duration)ttl, null, String.class, CalmDown.class).build();
        }
        this.lastWarnSlow = WingsCache2k.builder(WingsOverloadFilter.class, (String)"lastWarnSlow", (int)2000, (Duration)Duration.ofHours(2L), null, String.class, Long.class).build();
        this.responseCost = config.responseInfoStat <= 0L ? new AtomicLong[0] : new AtomicLong[500];
        for (int i = 0; i < this.responseCost.length; ++i) {
            this.responseCost[i] = new AtomicLong(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.requestProcess.get() > this.requestCapacity.get()) {
            this.fallBack.fallback(request, response);
            return;
        }
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpReq = (HttpServletRequest)request;
        long now = ThreadNow.millis();
        CalmDown calmDown = this.letCalmDown(httpReq);
        if (calmDown != null) {
            boolean isFst;
            int rqs = calmDown.heardRequest.incrementAndGet();
            boolean isCnt = rqs >= this.config.requestCalmdown;
            boolean bl = isFst = now - calmDown.firstRequest.get() < this.config.requestInterval;
            if (isCnt && isFst) {
                long lwl;
                this.fallBack.fallback(request, response);
                Long lw = (Long)this.lastWarnSlow.get((Object)calmDown.ip);
                long l = lwl = lw == null ? 0L : lw;
                if (log.isWarnEnabled() && now > this.config.getLogInterval() + lwl) {
                    log.warn("wings-clam-request, now={}, ip={}, uri={}", new Object[]{rqs, calmDown.ip, httpReq.getRequestURI()});
                    this.lastWarnSlow.put((Object)calmDown.ip, (Object)now);
                }
                return;
            }
            if (!isFst) {
                calmDown.firstRequest.set(now);
            }
            if (isCnt) {
                calmDown.heardRequest.addAndGet(-rqs);
            }
        }
        this.requestProcess.incrementAndGet();
        try {
            chain.doFilter(request, response);
            this.checkAndStats(httpReq, response, now, ThreadNow.millis());
        }
        finally {
            this.requestProcess.decrementAndGet();
        }
    }

    public void setRequestCapacity(int capacity) {
        this.requestCapacity.set(capacity);
    }

    public int getRequestProcess() {
        return this.requestProcess.get();
    }

    private CalmDown letCalmDown(HttpServletRequest httpReq) {
        if (this.spiderCache == null) {
            return null;
        }
        String ip = this.terminalResolver.resolveRemoteIp(httpReq);
        for (String p : this.config.requestPermit.values()) {
            if (!ip.startsWith(p) || p.isEmpty()) continue;
            return null;
        }
        return (CalmDown)this.spiderCache.computeIfAbsent((Object)ip, CalmDown::new);
    }

    private int initCapacity(Config config) {
        if (config.requestCapacity > 0) {
            return config.requestCapacity;
        }
        if (config.requestCapacity < 0) {
            return Integer.MAX_VALUE;
        }
        int cnt = Runtime.getRuntime().availableProcessors() * 300;
        return Math.max(cnt, 2000);
    }

    private void checkAndStats(HttpServletRequest request, ServletResponse response, long bgn, long end) {
        if (!(response instanceof HttpServletResponse)) {
            return;
        }
        HttpServletResponse res = (HttpServletResponse)response;
        if (res.getStatus() != 200) {
            return;
        }
        long cost = end - bgn;
        long warnSlow = this.config.responseWarnSlow;
        if (log.isWarnEnabled() && warnSlow > 0L && cost > warnSlow) {
            long lwl;
            String uri = request.getRequestURI();
            Long lw = (Long)this.lastWarnSlow.get((Object)uri);
            long l = lwl = lw == null ? 0L : lw;
            if (end > this.config.getLogInterval() + lwl) {
                log.warn("wings-slow-response, slow={}, cost={}, uri={}", new Object[]{warnSlow, cost, uri});
                this.lastWarnSlow.put((Object)uri, (Object)end);
            }
        }
        if (this.responseCost.length > 0) {
            int idx = (int)(cost % 20L);
            if (idx >= this.responseCost.length) {
                this.responseCost[this.responseCost.length - 1].incrementAndGet();
            } else {
                this.responseCost[idx].incrementAndGet();
            }
            long total = this.responseTotal.incrementAndGet();
            if (log.isInfoEnabled() && (this.config.responseInfoStat == 0L || total % this.config.responseInfoStat == 0L) && end - this.lastInfoStat.get() > this.config.responseInfoStat) {
                long sum = 0L;
                int p99 = 0;
                int p95 = 0;
                int p90 = 0;
                for (int i = 0; i < this.responseCost.length; ++i) {
                    long rate = (sum += this.responseCost[i].get()) * 100L / total;
                    if (rate >= 99L && p99 == 0) {
                        p99 = 20 * i;
                    }
                    if (rate >= 95L && p95 == 0) {
                        p95 = 20 * i;
                    }
                    if (rate < 90L || p90 != 0) continue;
                    p90 = 20 * i;
                }
                log.info("wings-snap-response , total-resp=" + total + ", p99=" + p99 + ", p95=" + p95 + ", p90=" + p90 + ", process=" + this.requestProcess.get() + ", capacity=" + this.requestCapacity.get());
                this.lastInfoStat.set(end);
            }
        }
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public AtomicInteger getRequestCapacity() {
        return this.requestCapacity;
    }

    @Generated
    public AtomicLong getLastInfoStat() {
        return this.lastInfoStat;
    }

    @Generated
    public int getCostStep() {
        return this.costStep;
    }

    @Generated
    public AtomicLong[] getResponseCost() {
        return this.responseCost;
    }

    @Generated
    public AtomicLong getResponseTotal() {
        return this.responseTotal;
    }

    @Generated
    public FallBack getFallBack() {
        return this.fallBack;
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public WingsRemoteResolver getTerminalResolver() {
        return this.terminalResolver;
    }

    @Generated
    public Cache<String, CalmDown> getSpiderCache() {
        return this.spiderCache;
    }

    @Generated
    public Cache<String, Long> getLastWarnSlow() {
        return this.lastWarnSlow;
    }

    public static interface FallBack {
        public void fallback(ServletRequest var1, ServletResponse var2);
    }

    public static class Config {
        private long logInterval = 3000L;
        private int fallbackCode = 200;
        private String fallbackBody = "";
        private int requestCapacity = 9000;
        private long requestInterval = 1000L;
        private int requestCalmdown = 50;
        private Map<String, String> requestPermit = Collections.emptyMap();
        private long responseWarnSlow = 5000L;
        private long responseInfoStat = 1000L;

        @Generated
        public Config() {
        }

        @Generated
        public long getLogInterval() {
            return this.logInterval;
        }

        @Generated
        public int getFallbackCode() {
            return this.fallbackCode;
        }

        @Generated
        public String getFallbackBody() {
            return this.fallbackBody;
        }

        @Generated
        public int getRequestCapacity() {
            return this.requestCapacity;
        }

        @Generated
        public long getRequestInterval() {
            return this.requestInterval;
        }

        @Generated
        public int getRequestCalmdown() {
            return this.requestCalmdown;
        }

        @Generated
        public Map<String, String> getRequestPermit() {
            return this.requestPermit;
        }

        @Generated
        public long getResponseWarnSlow() {
            return this.responseWarnSlow;
        }

        @Generated
        public long getResponseInfoStat() {
            return this.responseInfoStat;
        }

        @Generated
        public void setLogInterval(long logInterval) {
            this.logInterval = logInterval;
        }

        @Generated
        public void setFallbackCode(int fallbackCode) {
            this.fallbackCode = fallbackCode;
        }

        @Generated
        public void setFallbackBody(String fallbackBody) {
            this.fallbackBody = fallbackBody;
        }

        @Generated
        public void setRequestCapacity(int requestCapacity) {
            this.requestCapacity = requestCapacity;
        }

        @Generated
        public void setRequestInterval(long requestInterval) {
            this.requestInterval = requestInterval;
        }

        @Generated
        public void setRequestCalmdown(int requestCalmdown) {
            this.requestCalmdown = requestCalmdown;
        }

        @Generated
        public void setRequestPermit(Map<String, String> requestPermit) {
            this.requestPermit = requestPermit;
        }

        @Generated
        public void setResponseWarnSlow(long responseWarnSlow) {
            this.responseWarnSlow = responseWarnSlow;
        }

        @Generated
        public void setResponseInfoStat(long responseInfoStat) {
            this.responseInfoStat = responseInfoStat;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLogInterval() != other.getLogInterval()) {
                return false;
            }
            if (this.getFallbackCode() != other.getFallbackCode()) {
                return false;
            }
            if (this.getRequestCapacity() != other.getRequestCapacity()) {
                return false;
            }
            if (this.getRequestInterval() != other.getRequestInterval()) {
                return false;
            }
            if (this.getRequestCalmdown() != other.getRequestCalmdown()) {
                return false;
            }
            if (this.getResponseWarnSlow() != other.getResponseWarnSlow()) {
                return false;
            }
            if (this.getResponseInfoStat() != other.getResponseInfoStat()) {
                return false;
            }
            String this$fallbackBody = this.getFallbackBody();
            String other$fallbackBody = other.getFallbackBody();
            if (this$fallbackBody == null ? other$fallbackBody != null : !this$fallbackBody.equals(other$fallbackBody)) {
                return false;
            }
            Map<String, String> this$requestPermit = this.getRequestPermit();
            Map<String, String> other$requestPermit = other.getRequestPermit();
            return !(this$requestPermit == null ? other$requestPermit != null : !((Object)this$requestPermit).equals(other$requestPermit));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Config;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $logInterval = this.getLogInterval();
            result = result * 59 + (int)($logInterval >>> 32 ^ $logInterval);
            result = result * 59 + this.getFallbackCode();
            result = result * 59 + this.getRequestCapacity();
            long $requestInterval = this.getRequestInterval();
            result = result * 59 + (int)($requestInterval >>> 32 ^ $requestInterval);
            result = result * 59 + this.getRequestCalmdown();
            long $responseWarnSlow = this.getResponseWarnSlow();
            result = result * 59 + (int)($responseWarnSlow >>> 32 ^ $responseWarnSlow);
            long $responseInfoStat = this.getResponseInfoStat();
            result = result * 59 + (int)($responseInfoStat >>> 32 ^ $responseInfoStat);
            String $fallbackBody = this.getFallbackBody();
            result = result * 59 + ($fallbackBody == null ? 43 : $fallbackBody.hashCode());
            Map<String, String> $requestPermit = this.getRequestPermit();
            result = result * 59 + ($requestPermit == null ? 43 : ((Object)$requestPermit).hashCode());
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "WingsOverloadFilter.Config(logInterval=" + this.getLogInterval() + ", fallbackCode=" + this.getFallbackCode() + ", fallbackBody=" + this.getFallbackBody() + ", requestCapacity=" + this.getRequestCapacity() + ", requestInterval=" + this.getRequestInterval() + ", requestCalmdown=" + this.getRequestCalmdown() + ", requestPermit=" + String.valueOf(this.getRequestPermit()) + ", responseWarnSlow=" + this.getResponseWarnSlow() + ", responseInfoStat=" + this.getResponseInfoStat() + ")";
        }
    }

    private static class CalmDown {
        private final String ip;
        private final AtomicLong firstRequest = new AtomicLong(0L);
        private final AtomicInteger heardRequest = new AtomicInteger(0);

        @Generated
        public CalmDown(String ip) {
            this.ip = ip;
        }
    }
}

