/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.servlet.stream;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.springframework.web.util.WebUtils;

public class ReuseStreamResponseWrapper
extends ContentCachingResponseWrapper {
    private boolean caching = false;
    private boolean backend = false;

    public static ReuseStreamResponseWrapper infer(ServletResponse response) {
        return (ReuseStreamResponseWrapper)((Object)WebUtils.getNativeResponse((ServletResponse)response, ReuseStreamResponseWrapper.class));
    }

    public ReuseStreamResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public boolean cachingOutputStream(boolean quiet) {
        if (this.backend) {
            if (quiet) {
                return false;
            }
            throw new IllegalStateException("MUST caching before using");
        }
        this.caching = true;
        return true;
    }

    @NotNull
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.caching) {
            return super.getOutputStream();
        }
        this.backend = true;
        return this.getResponse().getOutputStream();
    }

    @NotNull
    public PrintWriter getWriter() throws IOException {
        if (this.caching) {
            return super.getWriter();
        }
        this.backend = true;
        return this.getResponse().getWriter();
    }

    public void flushBuffer() throws IOException {
        if (!this.caching) {
            this.backend = true;
            this.getResponse().flushBuffer();
        }
    }

    public void setContentLength(int len) {
        if (this.caching) {
            super.setContentLength(len);
        } else {
            this.backend = true;
            this.getResponse().setContentLength(len);
        }
    }

    public void setContentLengthLong(long len) {
        if (this.caching) {
            super.setContentLengthLong(len);
        } else {
            this.backend = true;
            this.getResponse().setContentLengthLong(len);
        }
    }

    public void setBufferSize(int size) {
        if (this.caching) {
            super.setBufferSize(size);
        } else {
            this.backend = true;
            this.getResponse().setBufferSize(size);
        }
    }

    public void resetBuffer() {
        if (this.caching) {
            super.resetBuffer();
        } else {
            this.backend = true;
            this.getResponse().resetBuffer();
        }
    }
}

