/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import pro.fessional.mirana.code.RandCode;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.concur.impl.FirstBloodHandler;
import pro.fessional.wings.slardar.concur.impl.FirstBloodImageHandler;
import pro.fessional.wings.slardar.concur.impl.FirstBloodInterceptor;
import pro.fessional.wings.slardar.servlet.resolver.WingsRemoteResolver;
import pro.fessional.wings.slardar.servlet.response.view.PlainTextView;
import pro.fessional.wings.slardar.spring.prop.SlardarFirstBloodProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled(abs="wings.enabled.slardar.first-blood", value=false)
public class SlardarFirstBloodConfiguration {
    private static final Log log = LogFactory.getLog(SlardarFirstBloodConfiguration.class);

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.slardar.first-blood-image")
    @Order(value=-30000000)
    public FirstBloodImageHandler firstBloodImageHandler(@Autowired(required=false) WingsRemoteResolver remoteResolver, SlardarFirstBloodProp prop) {
        log.info((Object)"SlardarWebmvc spring-bean firstBloodImageHandler");
        FirstBloodImageHandler handler = new FirstBloodImageHandler();
        handler.setScenePrefix(prop.getCaptchaPrefix());
        handler.setClientTicketKey(prop.getClientTicketKey());
        handler.setQuestCaptchaKey(prop.getQuestCaptchaKey());
        handler.setCheckCaptchaKey(prop.getCheckCaptchaKey());
        handler.setBase64CaptchaKey(prop.getBase64CaptchaKey());
        handler.setBase64CaptchaBody(prop.getBase64CaptchaBody());
        ModelAndView mav = new ModelAndView();
        PlainTextView pv = new PlainTextView(prop.getContentType(), prop.getResponseBody());
        mav.setStatus((HttpStatusCode)HttpStatus.valueOf((int)prop.getHttpStatus()));
        mav.setView((View)pv);
        handler.setNeedCaptchaResponse(mav);
        handler.setWingsRemoteResolver(remoteResolver);
        handler.setCaseIgnore(prop.isCaseIgnore());
        if (prop.isChineseCaptcha()) {
            log.info((Object)"SlardarWebmvc conf firstBloodImageHandler ChineseCaptcha");
            handler.setCaptchaSupplier(() -> RandCode.mix((int)4));
        }
        return handler;
    }

    @Bean
    @ConditionalWingsEnabled
    public FirstBloodInterceptor firstBloodInterceptor(ObjectProvider<FirstBloodHandler> providers) {
        List<FirstBloodHandler> handlers = providers.orderedStream().collect(Collectors.toList());
        log.info((Object)("SlardarWebmvc spring-bean firstBloodInterceptor, handlers count=" + handlers.size()));
        return new FirstBloodInterceptor(handlers);
    }
}

