/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import okhttp3.OkHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.client.RestTemplateBuilderConfigurer;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={OkHttpClient.class})
@ConditionalWingsEnabled
public class SlardarOkhttpWebConfiguration {
    private static final Log log = LogFactory.getLog(SlardarOkhttpWebConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public RestTemplate okhttpRestTemplate(RestTemplateBuilder builder) {
        log.info((Object)"SlardarWebmvc spring-bean okRestTemplate");
        return builder.build();
    }

    @Bean
    @ConditionalWingsEnabled
    public RestTemplateBuilder restTemplateBuilder(RestTemplateBuilderConfigurer configurer, OkHttpClient client) {
        log.info((Object)"SlardarWebmvc spring-bean restTemplateBuilder");
        RestTemplateBuilder builder = configurer.configure(new RestTemplateBuilder(new RestTemplateCustomizer[0]));
        return builder.requestFactory(() -> new OkHttp3ClientHttpRequestFactory(client));
    }
}

