/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.domainx;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.cache2k.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.util.ServletRequestPathUtils;
import pro.fessional.wings.slardar.cache.cache2k.WingsCache2k;
import pro.fessional.wings.slardar.domainx.DomainRequestMatcher;
import pro.fessional.wings.slardar.domainx.DomainRequestWrapper;
import pro.fessional.wings.slardar.servlet.request.ResourceHttpRequestUtil;

public class DefaultDomainRequestMatcher
implements DomainRequestMatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDomainRequestMatcher.class);
    private final String pathPrefix;
    private final List<HandlerMapping> mappingUrl = new ArrayList<HandlerMapping>();
    private final AntPathMatcher antMatcher = new AntPathMatcher();
    private final LinkedHashSet<String> otherUrl = new LinkedHashSet();
    private final Cache<String, Boolean> matchedUrl;
    private final Cache<String, Boolean> notfoundUrl;
    private final Supplier<List<HandlerMapping>> handlerMappingSupplier;
    private volatile boolean initMapping = false;

    public DefaultDomainRequestMatcher(String pathPrefix, Collection<String> otherUrl, int cacheSize, Supplier<List<HandlerMapping>> supplier) {
        this.pathPrefix = pathPrefix;
        this.otherUrl.addAll(otherUrl);
        this.matchedUrl = WingsCache2k.builder(DefaultDomainRequestMatcher.class, (String)"matchedUrl", (int)cacheSize, (int)0, (int)0, String.class, Boolean.class).build();
        this.notfoundUrl = WingsCache2k.builder(DefaultDomainRequestMatcher.class, (String)"notfoundUrl", (int)cacheSize, (int)0, (int)0, String.class, Boolean.class).build();
        this.handlerMappingSupplier = supplier;
    }

    @Override
    public HttpServletRequest match(HttpServletRequest request, String domain) {
        this.checkInitMapping();
        String domainUrl = this.pathPrefix + domain + request.getRequestURI();
        DomainRequestWrapper wrapper = new DomainRequestWrapper(request);
        wrapper.setRequestURI(domainUrl);
        Boolean b = (Boolean)this.matchedUrl.get((Object)domainUrl);
        if (b != null && b.booleanValue()) {
            return wrapper;
        }
        for (String u : this.otherUrl) {
            if (!this.antMatcher.match(u, domainUrl)) continue;
            this.matchedUrl.put((Object)domainUrl, (Object)Boolean.TRUE);
            return wrapper;
        }
        if (this.notfoundUrl.get((Object)domainUrl) != null) {
            return request;
        }
        ServletRequestPathUtils.parseAndCache((HttpServletRequest)wrapper);
        for (HandlerMapping hm : this.mappingUrl) {
            try {
                HandlerExecutionChain hdc = hm.getHandler((HttpServletRequest)wrapper);
                if (hdc == null) continue;
                log.debug("find handler={}, in {}", hdc.getClass(), (Object)hm.getClass());
                Object hd = hdc.getHandler();
                if (hd instanceof ResourceHttpRequestHandler) {
                    ResourceHttpRequestHandler rrh = (ResourceHttpRequestHandler)hd;
                    if (!ResourceHttpRequestUtil.existResource(rrh, (HttpServletRequest)wrapper)) continue;
                    this.matchedUrl.put((Object)domainUrl, (Object)Boolean.TRUE);
                    return wrapper;
                }
                this.matchedUrl.put((Object)domainUrl, (Object)Boolean.TRUE);
                return wrapper;
            }
            catch (Exception e) {
                log.warn("failed to getHandler in HandlerMapping=" + String.valueOf(hm.getClass()), (Throwable)e);
            }
        }
        this.notfoundUrl.put((Object)domainUrl, (Object)Boolean.TRUE);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitMapping() {
        if (this.initMapping) {
            return;
        }
        List<HandlerMapping> list = this.mappingUrl;
        synchronized (list) {
            if (this.initMapping) {
                return;
            }
            List<HandlerMapping> mappings = this.handlerMappingSupplier.get();
            if (mappings != null) {
                for (HandlerMapping mapping : mappings) {
                    log.info("add HandlerMapping={}", (Object)mapping.getClass());
                    this.mappingUrl.add(mapping);
                }
                this.initMapping = true;
            }
        }
    }
}

