/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.security.bind;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsPasswordService;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;
import pro.fessional.mirana.bits.MdHelp;
import pro.fessional.mirana.code.RandCode;
import pro.fessional.wings.slardar.errcode.AuthnErrorEnum;
import pro.fessional.wings.slardar.security.PasssaltEncoder;
import pro.fessional.wings.slardar.security.PasswordHelper;
import pro.fessional.wings.slardar.security.WingsAuthCheckService;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.slardar.security.WingsUserDetails;
import pro.fessional.wings.slardar.security.WingsUserDetailsService;
import pro.fessional.wings.slardar.security.bind.WingsBindAuthToken;
import pro.fessional.wings.slardar.security.impl.DefaultWingsAuthDetails;
import pro.fessional.wings.slardar.security.pass.DefaultPasssaltEncoder;

public class WingsBindAuthProvider
extends AbstractUserDetailsAuthenticationProvider {
    private static final Log log = LogFactory.getLog(WingsBindAuthProvider.class);
    private volatile String userNotFoundEncodedPassword = null;
    private boolean onlyWingsBindAuthnToken = false;
    private UserDetailsService userDetailsService;
    private PasswordEncoder passwordEncoder;
    private PasssaltEncoder passsaltEncoder;
    private UserDetailsPasswordService userDetailsPasswordService;
    private WingsAuthCheckService wingsAuthCheckService;

    public WingsBindAuthProvider(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
        this.passwordEncoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
        this.passsaltEncoder = new DefaultPasssaltEncoder(MdHelp.sha256);
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        WingsUserDetails wud;
        if (!(userDetails instanceof WingsUserDetails) || !(wud = (WingsUserDetails)userDetails).isPreAuthed()) {
            this.checkPassword(userDetails, authentication);
        }
        if (this.wingsAuthCheckService != null && userDetails instanceof WingsUserDetails) {
            WingsBindAuthToken wat;
            wud = (WingsUserDetails)userDetails;
            if (authentication instanceof WingsBindAuthToken && !this.wingsAuthCheckService.check(wud, wat = (WingsBindAuthToken)authentication)) {
                log.debug((Object)"Failed to post check userDetails and authentication");
                throw new BadCredentialsException(this.messages.getMessage(AuthnErrorEnum.BadCredentials.getCode(), AuthnErrorEnum.BadCredentials.getHint()));
            }
        }
    }

    protected void doAfterPropertiesSet() {
        Assert.notNull((Object)this.userDetailsService, (String)"A UserDetailsService must be set");
    }

    /*
     * Unable to fully structure code
     */
    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        this.prepareTimingAttackProtection();
        try {
            var6_3 = this.userDetailsService;
            if (!(var6_3 instanceof WingsUserDetailsService)) ** GOTO lbl-1000
            winUds = (WingsUserDetailsService)var6_3;
            if (authentication instanceof WingsBindAuthToken) {
                winTkn = (WingsBindAuthToken)authentication;
                userDetails = this.buildUserDetails(username, winUds, winTkn);
            } else lbl-1000:
            // 2 sources

            {
                userDetails = this.userDetailsService.loadUserByUsername(username);
            }
            if (userDetails == null) {
                throw new InternalAuthenticationServiceException("UserDetailsService returned null, which is an interface contract violation");
            }
            return userDetails;
        }
        catch (UsernameNotFoundException ex) {
            this.mitigateAgainstTimingAttack(authentication);
            throw ex;
        }
        catch (InternalAuthenticationServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InternalAuthenticationServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected Authentication createSuccessAuthentication(Object principal, Authentication authn, UserDetails details) {
        if (this.userDetailsPasswordService != null && this.passwordEncoder.upgradeEncoding(details.getPassword())) {
            String presentedPassword = this.presentPassword(details, authn);
            String newPassword = this.passwordEncoder.encode((CharSequence)presentedPassword);
            details = this.userDetailsPasswordService.updatePassword(details, newPassword);
        }
        return super.createSuccessAuthentication(principal, authn, details);
    }

    public boolean supports(Class<?> authentication) {
        if (this.onlyWingsBindAuthnToken) {
            return WingsBindAuthToken.class.isAssignableFrom(authentication);
        }
        return super.supports(authentication);
    }

    @NotNull
    protected UserDetails buildUserDetails(String username, WingsUserDetailsService winUds, WingsBindAuthToken winTkn) {
        WingsAuthDetails winAdt;
        Object obj = winTkn.getDetails();
        if (obj instanceof WingsAuthDetails) {
            WingsAuthDetails wad;
            winAdt = wad = (WingsAuthDetails)obj;
        } else {
            log.debug((Object)"WARN No-WingsAuthDetails-In-WingsUserDetailsService-And-WingsBindAuthToken");
            winAdt = new DefaultWingsAuthDetails(obj);
        }
        UserDetails userDetails = winUds.loadUserByUsername(username, winTkn.getAuthType(), winAdt);
        return userDetails;
    }

    protected void checkPassword(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) {
        if (authentication.getCredentials() == null) {
            log.debug((Object)"Failed to authenticate since no credentials provided");
            throw new BadCredentialsException(this.messages.getMessage(AuthnErrorEnum.BadCredentials.getCode(), AuthnErrorEnum.BadCredentials.getHint()));
        }
        String presentedPassword = this.presentPassword(userDetails, (Authentication)authentication);
        if (!this.passwordEncoder.matches((CharSequence)presentedPassword, userDetails.getPassword())) {
            log.debug((Object)"Failed to authenticate since password does not match stored value");
            throw new BadCredentialsException(this.messages.getMessage(AuthnErrorEnum.BadCredentials.getCode(), AuthnErrorEnum.BadCredentials.getHint()));
        }
    }

    protected String presentPassword(UserDetails details, Authentication auth) {
        String presentedPassword = auth.getCredentials().toString();
        if (this.passsaltEncoder != null && details instanceof WingsUserDetails) {
            WingsUserDetails dtl = (WingsUserDetails)details;
            PasswordHelper helper = new PasswordHelper(this.passwordEncoder, this.passsaltEncoder);
            presentedPassword = helper.salt(presentedPassword, dtl.getPasssalt());
        }
        return presentedPassword;
    }

    protected void prepareTimingAttackProtection() {
        if (this.userNotFoundEncodedPassword == null) {
            this.userNotFoundEncodedPassword = this.passwordEncoder.encode((CharSequence)RandCode.strong((int)20));
        }
    }

    protected void mitigateAgainstTimingAttack(UsernamePasswordAuthenticationToken authentication) {
        if (authentication.getCredentials() != null) {
            String presentedPassword = authentication.getCredentials().toString();
            this.passwordEncoder.matches((CharSequence)presentedPassword, this.userNotFoundEncodedPassword);
        }
    }

    public PasssaltEncoder getPasssaltEncoder() {
        return this.passsaltEncoder;
    }

    public void setPasssaltEncoder(PasssaltEncoder passsaltEncoder) {
        this.passsaltEncoder = passsaltEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)passwordEncoder, (String)"passwordEncoder cannot be null");
        this.passwordEncoder = passwordEncoder;
        this.userNotFoundEncodedPassword = null;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        Assert.notNull((Object)this.passwordEncoder, (String)"UserDetailsService cannot be null");
        this.userDetailsService = userDetailsService;
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsPasswordService(UserDetailsPasswordService userDetailsPasswordService) {
        this.userDetailsPasswordService = userDetailsPasswordService;
    }

    public UserDetailsPasswordService getUserDetailsPasswordService() {
        return this.userDetailsPasswordService;
    }

    public boolean isOnlyWingsBindAuthnToken() {
        return this.onlyWingsBindAuthnToken;
    }

    public void setOnlyWingsBindAuthnToken(boolean onlyWingsBindAuthnToken) {
        this.onlyWingsBindAuthnToken = onlyWingsBindAuthnToken;
    }

    public WingsAuthCheckService getWingsAuthCheckService() {
        return this.wingsAuthCheckService;
    }

    public void setWingsAuthCheckService(WingsAuthCheckService wingsAuthCheckService) {
        this.wingsAuthCheckService = wingsAuthCheckService;
    }
}

