/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.security.pass;

import org.springframework.security.crypto.password.PasswordEncoder;
import pro.fessional.mirana.bits.Md5;
import pro.fessional.mirana.time.ThreadNow;

public class BasicPasswordEncoder
implements PasswordEncoder {
    private static final String Splitter = "#";
    private final long deviation;

    public BasicPasswordEncoder(long deviation) {
        this.deviation = Math.abs(deviation);
    }

    public String encode(CharSequence rawPassword) {
        String pass = rawPassword.toString();
        long time = ThreadNow.millis();
        String hash = Md5.sum((String)(time + Splitter + pass), (boolean)false);
        return time + Splitter + hash;
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        String raw = rawPassword.toString();
        if (rawPassword.equals(encodedPassword)) {
            return true;
        }
        int pos = raw.indexOf(Splitter);
        if (pos <= 0 || pos >= raw.length() - 1) {
            return false;
        }
        long time = Long.parseLong(raw.substring(0, pos));
        if (Math.abs(ThreadNow.millis() - time) > this.deviation) {
            return false;
        }
        String hash1 = raw.substring(pos + 1);
        String hash2 = Md5.sum((String)(time + Splitter + encodedPassword), (boolean)false);
        return hash1.equalsIgnoreCase(hash2);
    }
}

