/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.servlet.stream;

import jakarta.servlet.http.HttpSession;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import pro.fessional.mirana.cast.TypedCastUtil;
import pro.fessional.wings.slardar.servlet.stream.RequestResponseLogging;
import pro.fessional.wings.slardar.servlet.stream.ReuseStreamRequestWrapper;
import pro.fessional.wings.slardar.servlet.stream.ReuseStreamResponseWrapper;

public abstract class AbstractRequestResponseLogging
implements RequestResponseLogging {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRequestResponseLogging.class);
    private String beforeRequestPrefix = "BeforeRequest:::";
    private String afterResponsePrefix = "AfterResponse:::";

    @Override
    public abstract Condition loggingConfig(@NotNull ReuseStreamRequestWrapper var1);

    @Override
    public void beforeRequest(@NotNull RequestResponseLogging.Conf cnf, @NotNull ReuseStreamRequestWrapper req) {
        if (!cnf.isRequestLogAfter()) {
            String msg = this.createRequestMessage((Condition)cnf, req);
            this.logging(msg);
        }
    }

    @Override
    public void afterResponse(@NotNull RequestResponseLogging.Conf cnf, @NotNull ReuseStreamRequestWrapper req, @NotNull ReuseStreamResponseWrapper res) {
        if (cnf.isRequestLogAfter()) {
            String reqMsg = this.createRequestMessage((Condition)cnf, req);
            this.logging(reqMsg);
        }
        String resMsg = this.createResponseMessage((Condition)cnf, req, res);
        this.logging(resMsg);
    }

    protected String createRequestMessage(@NotNull Condition cnf, @NotNull ReuseStreamRequestWrapper request) {
        Predicate<String> headCond;
        StringBuilder msg = new StringBuilder();
        msg.append(this.beforeRequestPrefix);
        msg.append(request.getRequestSeq()).append('#');
        msg.append(request.getMethod()).append(' ');
        msg.append(request.getRequestURI());
        if (cnf.isRequestQuery()) {
            this.buildRequestQuery(request, msg);
        }
        if (cnf.isRequestClient()) {
            this.buildRequestClient(request, msg);
        }
        if ((headCond = cnf.getRequestHeader()) != null) {
            this.buildRequestHeader(request, msg, headCond);
        }
        if (cnf.isRequestPayload()) {
            this.buildRequestPayload(request, msg);
        }
        return msg.toString();
    }

    protected void buildRequestPayload(@NotNull ReuseStreamRequestWrapper request, @NotNull StringBuilder msg) {
        request.circleInputStream(false);
        byte[] buf = request.getInputStream().readAllBytes();
        msg.append(", body=").append(new String(buf, request.getCharacterEncoding()));
    }

    protected void buildRequestHeader(@NotNull ReuseStreamRequestWrapper request, @NotNull StringBuilder msg, @NotNull Predicate<String> headCond) {
        HttpHeaders headers = new HttpHeaders();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String hd = (String)names.nextElement();
            if (!headCond.test(hd)) continue;
            Enumeration vl = request.getHeaders(hd);
            headers.addAll(hd, Collections.list(vl));
        }
        if (!headers.isEmpty()) {
            msg.append(", headers=").append(headers);
        }
    }

    protected void buildRequestClient(@NotNull ReuseStreamRequestWrapper request, @NotNull StringBuilder msg) {
        String user;
        HttpSession sid;
        String addr = request.getRemoteAddr();
        if (StringUtils.hasLength((String)addr)) {
            msg.append(", addr=").append(addr);
        }
        if ((sid = request.getSession(false)) != null) {
            msg.append(", sid=").append(sid.getId());
        }
        if ((user = request.getRemoteUser()) != null) {
            msg.append(", user=").append(user);
        }
    }

    protected void buildRequestQuery(@NotNull ReuseStreamRequestWrapper request, @NotNull StringBuilder msg) {
        String qs = request.getQueryString();
        if (qs != null) {
            msg.append('?').append(qs);
        }
    }

    protected String createResponseMessage(@NotNull Condition cnf, @NotNull ReuseStreamRequestWrapper request, @NotNull ReuseStreamResponseWrapper response) {
        StringBuilder msg = new StringBuilder();
        msg.append(this.afterResponsePrefix);
        msg.append(request.getRequestSeq()).append('#');
        msg.append(response.getStatus()).append(' ');
        msg.append(response.getContentType());
        Predicate<String> headCond = cnf.getResponseHeader();
        if (headCond != null) {
            this.buildResponseHeader(response, msg, headCond);
        }
        if (cnf.isResponsePayload()) {
            this.buildResponsePayload(response, msg);
        }
        return msg.toString();
    }

    protected void buildResponsePayload(ReuseStreamResponseWrapper response, StringBuilder msg) {
        response.cachingOutputStream(false);
        byte[] buf = response.getContentAsByteArray();
        msg.append(", body=").append(new String(buf, response.getCharacterEncoding()));
    }

    protected void buildResponseHeader(@NotNull ReuseStreamResponseWrapper response, @NotNull StringBuilder msg, @NotNull Predicate<String> headCond) {
        HttpHeaders headers = new HttpHeaders();
        Collection names = response.getHeaderNames();
        for (String hd : names) {
            if (!headCond.test(hd)) continue;
            List vl = TypedCastUtil.castList((Collection)response.getHeaders(hd));
            headers.addAll(hd, vl);
        }
        if (!headers.isEmpty()) {
            msg.append(", headers=").append(headers);
        }
    }

    protected void logging(@NotNull String message) {
        log.debug(message);
    }

    @Generated
    public void setBeforeRequestPrefix(String beforeRequestPrefix) {
        this.beforeRequestPrefix = beforeRequestPrefix;
    }

    @Generated
    public String getBeforeRequestPrefix() {
        return this.beforeRequestPrefix;
    }

    @Generated
    public void setAfterResponsePrefix(String afterResponsePrefix) {
        this.afterResponsePrefix = afterResponsePrefix;
    }

    @Generated
    public String getAfterResponsePrefix() {
        return this.afterResponsePrefix;
    }

    public static class Condition
    extends RequestResponseLogging.Conf {
        private boolean requestQuery = true;
        private boolean requestClient = true;
        private Predicate<String> requestHeader;
        private Predicate<String> responseHeader;

        @Generated
        public void setRequestQuery(boolean requestQuery) {
            this.requestQuery = requestQuery;
        }

        @Generated
        public void setRequestClient(boolean requestClient) {
            this.requestClient = requestClient;
        }

        @Generated
        public void setRequestHeader(Predicate<String> requestHeader) {
            this.requestHeader = requestHeader;
        }

        @Generated
        public void setResponseHeader(Predicate<String> responseHeader) {
            this.responseHeader = responseHeader;
        }

        @Generated
        public boolean isRequestQuery() {
            return this.requestQuery;
        }

        @Generated
        public boolean isRequestClient() {
            return this.requestClient;
        }

        @Generated
        public Predicate<String> getRequestHeader() {
            return this.requestHeader;
        }

        @Generated
        public Predicate<String> getResponseHeader() {
            return this.responseHeader;
        }
    }
}

