/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.session.DefaultCookieSerializerCustomizer;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.servlet.server.Session;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.session.web.http.CookieHttpSessionIdResolver;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.session.web.http.HeaderHttpSessionIdResolver;
import org.springframework.session.web.http.HttpSessionIdResolver;
import org.springframework.util.StringUtils;
import pro.fessional.mirana.best.AssertArgs;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.session.WingsSessionIdResolver;
import pro.fessional.wings.slardar.spring.prop.SlardarSessionProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled(abs="wings.enabled.slardar.session")
public class SlardarSessionConfiguration {
    private static final Log log = LogFactory.getLog(SlardarSessionConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public WingsSessionIdResolver httpSessionIdResolver(ObjectProvider<ServerProperties> serverProperties, ObjectProvider<CookieSerializer> cookieSerializer, ObjectProvider<DefaultCookieSerializerCustomizer> cookieSerializerCustomizers, SlardarSessionProp prop) {
        String headerName;
        log.info((Object)"SlardarWebmvc spring-bean httpSessionIdResolver");
        ArrayList<HttpSessionIdResolver> resolvers = new ArrayList<HttpSessionIdResolver>();
        if (StringUtils.hasText((String)prop.getCookieName())) {
            ServerProperties server = (ServerProperties)serverProperties.getIfAvailable();
            AssertArgs.notNull((Object)server, (String)"need `server.servlet.session.*` config");
            Session.Cookie cookie = server.getServlet().getSession().getCookie();
            String propName = prop.getCookieName();
            String servName = cookie.getName();
            if (propName.equals(servName)) {
                log.info((Object)("SlardarWebmvc conf cookieHttpSessionIdResolver by server.servlet.session.cookie.name=" + propName));
            } else {
                log.warn((Object)("SlardarWebmvc conf cookieHttpSessionIdResolver by cookie.name=" + propName + ", but server.servlet.session.cookie.name =" + servName));
            }
            CookieSerializer serializer = (CookieSerializer)cookieSerializer.getIfAvailable();
            if (serializer == null) {
                log.info((Object)"SlardarWebmvc conf httpSessionIdResolver CookieSerializer by default");
                DefaultCookieSerializer defaultCookieSerializer = new DefaultCookieSerializer();
                PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
                map.from((Object)propName).to(arg_0 -> ((DefaultCookieSerializer)defaultCookieSerializer).setCookieName(arg_0));
                map.from(() -> ((Session.Cookie)cookie).getDomain()).to(arg_0 -> ((DefaultCookieSerializer)defaultCookieSerializer).setDomainName(arg_0));
                map.from(() -> ((Session.Cookie)cookie).getPath()).to(arg_0 -> ((DefaultCookieSerializer)defaultCookieSerializer).setCookiePath(arg_0));
                map.from(() -> ((Session.Cookie)cookie).getHttpOnly()).to(arg_0 -> ((DefaultCookieSerializer)defaultCookieSerializer).setUseHttpOnlyCookie(arg_0));
                map.from(() -> ((Session.Cookie)cookie).getSecure()).to(arg_0 -> ((DefaultCookieSerializer)defaultCookieSerializer).setUseSecureCookie(arg_0));
                map.from(() -> ((Session.Cookie)cookie).getMaxAge()).to(maxAge -> defaultCookieSerializer.setCookieMaxAge((int)maxAge.getSeconds()));
                cookieSerializerCustomizers.orderedStream().forEach(customizer -> customizer.customize(defaultCookieSerializer));
                serializer = defaultCookieSerializer;
            }
            CookieHttpSessionIdResolver cookieHttpSessionIdResolver = new CookieHttpSessionIdResolver();
            cookieHttpSessionIdResolver.setCookieSerializer(serializer);
            resolvers.add((HttpSessionIdResolver)cookieHttpSessionIdResolver);
        }
        if (StringUtils.hasText((String)(headerName = prop.getHeaderName()))) {
            HeaderHttpSessionIdResolver headerHttpSessionIdResolver = new HeaderHttpSessionIdResolver(headerName);
            log.info((Object)("SlardarWebmvc conf headerHttpSessionIdResolver by header.name=" + headerName));
            resolvers.add((HttpSessionIdResolver)headerHttpSessionIdResolver);
        }
        return new WingsSessionIdResolver(resolvers);
    }

    @Bean
    @ConditionalWingsEnabled
    @Order(value=-29999990)
    public DefaultCookieSerializerCustomizer slardarCookieSerializerCustomizer(SlardarSessionProp prop) {
        log.info((Object)"SlardarWebmvc spring-bean slardarCookieSerializerCustomizer");
        return it -> {
            boolean base64 = prop.isCookieBase64();
            log.info((Object)("SlardarWebmvc conf Session Cookie Base64=" + base64));
            it.setUseBase64Encoding(base64);
            String jvmRoute = prop.getCookieRoute();
            if (StringUtils.hasText((String)jvmRoute)) {
                log.info((Object)("SlardarWebmvc conf Session Cookie jvmRoute=" + jvmRoute));
                it.setJvmRoute(jvmRoute);
            }
        };
    }
}

