/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.concur.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import pro.fessional.mirana.bits.Aes;
import pro.fessional.mirana.bits.Aes256;
import pro.fessional.mirana.bits.Base64;
import pro.fessional.mirana.bits.MdHelp;
import pro.fessional.mirana.code.RandCode;
import pro.fessional.wings.slardar.concur.Righter;
import pro.fessional.wings.slardar.concur.impl.RighterContext;
import pro.fessional.wings.slardar.serialize.KryoSimple;
import pro.fessional.wings.slardar.servlet.response.ResponseHelper;
import pro.fessional.wings.slardar.spring.prop.SlardarRighterProp;
import pro.fessional.wings.slardar.webmvc.AutoRegisterInterceptor;

public class RighterInterceptor
implements AutoRegisterInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RighterInterceptor.class);
    public static final int ORDER = -29999000;
    public static final String Secret = RandCode.strong((int)20);
    private final SlardarRighterProp prop;
    private int order = -29999000;
    private SecretProvider secretProvider = null;

    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod hm = (HandlerMethod)handler;
        Righter anno = hm.getMethod().getAnnotation(Righter.class);
        if (anno == null) {
            return true;
        }
        RighterContext.delAudit();
        HttpSession session = request.getSession(false);
        String audit = request.getHeader(this.prop.getHeader());
        if (audit == null) {
            if (anno.value()) {
                this.responseError(response);
                return false;
            }
            RighterContext.funAllow(obj -> {
                String key = this.getKey(session);
                String allow = this.encodeAllow(key, obj);
                int len = allow.length();
                if (len > 5000) {
                    log.warn("browser may 8k header, but 4k is too much. uri={}", (Object)request.getRequestURI());
                }
                response.setHeader(this.prop.getHeader(), allow);
            });
            return true;
        }
        if (session == null) {
            return true;
        }
        String key = this.getKey(session);
        byte[] bytes = this.decodeAudit(key, audit);
        if (bytes == null) {
            log.debug("failed to check digest. session={}, audit={}", (Object)session.getId(), (Object)audit);
            this.responseError(response);
            return false;
        }
        try {
            Object obj2 = KryoSimple.readClassAndObject((byte[])bytes);
            RighterContext.setAudit(obj2);
            return true;
        }
        catch (Exception e) {
            log.info("failed to deserialize. session=" + String.valueOf(session) + ", audit=" + audit, (Throwable)e);
            this.responseError(response);
            return false;
        }
    }

    private void responseError(HttpServletResponse response) {
        response.setStatus(this.prop.getHttpStatus());
        response.setContentType(this.prop.getContentType());
        ResponseHelper.writeBodyUtf8(response, this.prop.getResponseBody());
    }

    public void postHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler, ModelAndView modelAndView) {
        RighterContext.delAllow();
    }

    private String getKey(HttpSession session) {
        String k;
        if (this.secretProvider != null && (k = (String)this.secretProvider.apply(session)) != null && !k.isEmpty()) {
            return k;
        }
        return Secret;
    }

    private Aes genAesKey(String k) {
        int len = k.length();
        int min = 20;
        if (len < 20) {
            k = k.repeat(19 / len + 1);
        }
        return Aes256.of((String)k);
    }

    private String encodeAllow(String key, Object obj) {
        byte[] bytes = KryoSimple.writeClassAndObject((Object)obj);
        Aes aes = this.genAesKey(key);
        String b64 = Base64.encode((byte[])aes.encode(bytes));
        String sum = MdHelp.sha1.sum(b64 + key);
        return sum + b64;
    }

    private byte[] decodeAudit(String key, String audit) {
        String b64;
        int sha1Pos = 40;
        if (audit.length() <= 40) {
            return null;
        }
        String sum = audit.substring(0, 40);
        if (MdHelp.sha1.check(sum, (b64 = audit.substring(40)) + key)) {
            byte[] bys = Base64.decode((String)b64);
            Aes aes = this.genAesKey(key);
            return aes.decode(bys);
        }
        return null;
    }

    @Generated
    public RighterInterceptor(SlardarRighterProp prop) {
        this.prop = prop;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setSecretProvider(SecretProvider secretProvider) {
        this.secretProvider = secretProvider;
    }

    @Generated
    public SecretProvider getSecretProvider() {
        return this.secretProvider;
    }

    public static interface SecretProvider
    extends Function<HttpSession, String> {
    }
}

