/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.context;

import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import pro.fessional.mirana.cast.TypedCastUtil;
import pro.fessional.wings.slardar.context.SecurityContextException;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.slardar.security.WingsUserDetails;

public class SecurityContextUtil {
    @NotNull
    public static Collection<GrantedAuthority> getAuthorities() {
        Authentication atn = SecurityContextUtil.getAuthentication(false);
        if (atn == null) {
            return Collections.emptyList();
        }
        Collection ats = atn.getAuthorities();
        if (ats == null) {
            return Collections.emptyList();
        }
        return ats;
    }

    @NotNull
    public static <T extends GrantedAuthority> Collection<T> getAuthorities(Class<T> claz) {
        Authentication atn = SecurityContextUtil.getAuthentication(false);
        if (atn == null) {
            return Collections.emptyList();
        }
        return TypedCastUtil.castCollection((Collection)atn.getAuthorities(), claz);
    }

    @NotNull
    public static Authentication getAuthentication() throws SecurityContextException {
        return SecurityContextUtil.getAuthentication(true);
    }

    @Contract(value="true -> !null")
    public static Authentication getAuthentication(boolean notnull) throws SecurityContextException {
        Authentication an = SecurityContextHolder.getContext().getAuthentication();
        if (an == null && notnull) {
            throw new SecurityContextException("failed to getAuthentication");
        }
        return an;
    }

    @NotNull
    public static WingsAuthDetails getAuthDetails() throws SecurityContextException {
        return SecurityContextUtil.getAuthDetails(true);
    }

    @Contract(value="true -> !null")
    public static WingsAuthDetails getAuthDetails(boolean notnull) throws SecurityContextException {
        WingsAuthDetails an = SecurityContextUtil.getAuthDetails(WingsAuthDetails.class);
        if (an == null && notnull) {
            throw new SecurityContextException("failed to getAuthDetails");
        }
        return an;
    }

    @Nullable
    public static <T> T getAuthDetails(Class<T> claz) {
        Authentication atn = SecurityContextUtil.getAuthentication(false);
        return SecurityContextUtil.getAuthDetails(claz, atn);
    }

    @Nullable
    public static WingsAuthDetails getAuthDetails(Authentication atn) {
        return SecurityContextUtil.getAuthDetails(WingsAuthDetails.class, atn);
    }

    @Nullable
    public static <T> T getAuthDetails(Class<T> claz, Authentication atn) {
        if (atn == null) {
            return null;
        }
        return (T)TypedCastUtil.castObject((Object)atn.getDetails(), claz);
    }

    @NotNull
    public static <T> T getPrincipal() throws SecurityContextException {
        return SecurityContextUtil.getPrincipal(true);
    }

    @Contract(value="true -> !null")
    public static <T> T getPrincipal(boolean notnull) throws SecurityContextException {
        Authentication atn = SecurityContextUtil.getAuthentication(notnull);
        Object pt = atn.getPrincipal();
        if (pt == null && notnull) {
            throw new SecurityContextException("failed to getPrincipal");
        }
        return (T)pt;
    }

    @Nullable
    public static <T> T getPrincipal(Class<T> claz) {
        Authentication atn = SecurityContextUtil.getAuthentication(false);
        if (atn == null) {
            return null;
        }
        return (T)TypedCastUtil.castObject((Object)atn.getPrincipal(), claz);
    }

    @Nullable
    public static <T> T getCredentials() {
        Authentication atn = SecurityContextUtil.getAuthentication(false);
        if (atn == null) {
            return null;
        }
        return (T)atn.getCredentials();
    }

    @Nullable
    public static <T> T getCredentials(Class<T> claz) {
        Authentication atn = SecurityContextUtil.getAuthentication(false);
        if (atn == null) {
            return null;
        }
        return (T)TypedCastUtil.castObject((Object)atn.getCredentials(), claz);
    }

    @NotNull
    public static WingsUserDetails getUserDetails() throws SecurityContextException {
        return SecurityContextUtil.getUserDetails(true);
    }

    @Contract(value="true -> !null")
    public static WingsUserDetails getUserDetails(boolean notnull) throws SecurityContextException {
        WingsUserDetails dt = SecurityContextUtil.getUserDetails(SecurityContextUtil.getAuthentication(notnull));
        if (dt == null && notnull) {
            throw new SecurityContextException("failed to getUserDetails");
        }
        return dt;
    }

    @Nullable
    public static WingsUserDetails getUserDetails(SecurityContext context) {
        if (context == null) {
            return null;
        }
        return SecurityContextUtil.getUserDetails(context.getAuthentication());
    }

    @Nullable
    public static WingsUserDetails getUserDetails(Authentication atn) {
        WingsAuthDetails wad;
        Object rd;
        if (atn == null) {
            return null;
        }
        Object pri = atn.getPrincipal();
        if (pri instanceof WingsUserDetails) {
            WingsUserDetails w1 = (WingsUserDetails)pri;
            return w1;
        }
        Object dtl = atn.getDetails();
        if (dtl instanceof WingsUserDetails) {
            WingsUserDetails w2 = (WingsUserDetails)dtl;
            return w2;
        }
        if (dtl instanceof WingsAuthDetails && (rd = (wad = (WingsAuthDetails)dtl).getRealData()) instanceof WingsUserDetails) {
            WingsUserDetails w3 = (WingsUserDetails)rd;
            return w3;
        }
        return null;
    }

    public static long getUserId() {
        return SecurityContextUtil.getUserId(true);
    }

    @Contract(value="true -> !null")
    public static Long getUserId(boolean notnull) throws SecurityContextException {
        WingsUserDetails dtl = SecurityContextUtil.getUserDetails(notnull);
        return dtl == null ? null : Long.valueOf(dtl.getUserId());
    }
}

