/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.httprest;

import java.io.File;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import pro.fessional.mirana.data.Null;

public class RestTemplateHelper {
    public static final ResponseErrorHandler NopErrorHandler = new ResponseErrorHandler(){

        public boolean hasError(@NotNull ClientHttpResponse response) {
            return false;
        }

        public void handleError(@NotNull ClientHttpResponse response) {
        }
    };

    @NotNull
    public static HttpHeaders header(MediaType mediaType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(mediaType);
        headers.setConnection("Keep-Alive");
        headers.setCacheControl("no-cache");
        return headers;
    }

    @NotNull
    public static <T> MultiValueMap<String, T> body() {
        return new LinkedMultiValueMap();
    }

    @NotNull
    public static <T> MultiValueMap<String, T> body(@Nullable HttpEntity<MultiValueMap<String, T>> entity) {
        MultiValueMap body = entity == null ? null : (MultiValueMap)entity.getBody();
        return body == null ? new LinkedMultiValueMap() : body;
    }

    @NotNull
    public static HttpHeaders jsonHeader() {
        return RestTemplateHelper.header(MediaType.APPLICATION_JSON);
    }

    @NotNull
    public static HttpEntity<String> jsonEntity(String json) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return new HttpEntity((Object)json, (MultiValueMap)headers);
    }

    @NotNull
    public static <T> HttpEntity<T> jsonEntity(T obj) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return new HttpEntity(obj, (MultiValueMap)headers);
    }

    @NotNull
    public static HttpHeaders formHeader() {
        return RestTemplateHelper.header(MediaType.APPLICATION_FORM_URLENCODED);
    }

    @NotNull
    public static HttpEntity<MultiValueMap<String, String>> formEntity() {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        return new HttpEntity((Object)map, (MultiValueMap)RestTemplateHelper.formHeader());
    }

    @NotNull
    public static HttpHeaders fileHeader() {
        return RestTemplateHelper.header(MediaType.MULTIPART_FORM_DATA);
    }

    @NotNull
    public static HttpEntity<MultiValueMap<String, Object>> fileEntity() {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        return new HttpEntity((Object)map, (MultiValueMap)RestTemplateHelper.fileHeader());
    }

    @NotNull
    public static MultiValueMap<String, Object> addFile(HttpEntity<MultiValueMap<String, Object>> entity, String key, File file) {
        return RestTemplateHelper.addFile(entity, key, (Resource)new FileSystemResource(file), file.getName());
    }

    @NotNull
    public static MultiValueMap<String, Object> addFile(HttpEntity<MultiValueMap<String, Object>> entity, String key, byte[] file, String fileName) {
        return RestTemplateHelper.addFile(entity, key, (Resource)new ByteArrayResource(file), fileName);
    }

    @NotNull
    public static MultiValueMap<String, Object> addFile(HttpEntity<MultiValueMap<String, Object>> entity, String key, InputStream file, String fileName) {
        return RestTemplateHelper.addFile(entity, key, (Resource)new InputStreamResource(file), fileName);
    }

    @NotNull
    public static MultiValueMap<String, Object> addFile(HttpEntity<MultiValueMap<String, Object>> entity, String key, Resource res, String fileName) {
        MultiValueMap<String, Object> body = RestTemplateHelper.body(entity);
        LinkedMultiValueMap file = new LinkedMultiValueMap();
        ContentDisposition contentDisposition = ContentDisposition.builder((String)"form-data").name(key).filename(fileName).build();
        file.add((Object)"Content-Disposition", (Object)contentDisposition.toString());
        body.add((Object)key, (Object)new HttpEntity((Object)res, (MultiValueMap)file));
        return body;
    }

    public static byte @NotNull [] download(RestTemplate tmpl, String url) {
        return RestTemplateHelper.download(tmpl, url, HttpMethod.GET);
    }

    public static byte @NotNull [] download(RestTemplate tmpl, String url, HttpMethod method) {
        ResponseEntity res;
        byte[] arr;
        HttpEntity entity = new HttpEntity((MultiValueMap)RestTemplateHelper.header(MediaType.APPLICATION_OCTET_STREAM));
        if (method == null) {
            method = HttpMethod.GET;
        }
        return (arr = (byte[])RestTemplateHelper.extract(res = tmpl.exchange(url, method, entity, byte[].class, new Object[0]))) == null ? Null.Bytes : arr;
    }

    @Nullable
    public static <T> T extract(ResponseEntity<T> res) {
        if (res.getStatusCode().is2xxSuccessful()) {
            return (T)res.getBody();
        }
        return null;
    }
}

