/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.security;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import pro.fessional.wings.slardar.context.TerminalAttribute;
import pro.fessional.wings.slardar.context.TerminalContext;
import pro.fessional.wings.slardar.context.TerminalSecurityAttribute;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.slardar.security.WingsUserDetails;
import pro.fessional.wings.slardar.security.bind.WingsBindAuthToken;

public class WingsAuthenticationEventPublisher
extends DefaultAuthenticationEventPublisher {
    public WingsAuthenticationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        super(applicationEventPublisher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishAuthenticationSuccess(Authentication authentication) {
        Object object = authentication.getPrincipal();
        if (!(object instanceof WingsUserDetails)) {
            super.publishAuthenticationSuccess(authentication);
            return;
        }
        WingsUserDetails userDetails = (WingsUserDetails)object;
        TerminalContext.Builder builder = new TerminalContext.Builder().locale(userDetails.getLocale()).timeZone(userDetails.getZoneId()).user(userDetails.getUserId()).authType(userDetails.getAuthType()).username(userDetails.getUsername()).authPerm((Collection)userDetails.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet())).terminal(TerminalSecurityAttribute.UserDetails, (Object)userDetails);
        this.buildTerminal(builder, authentication);
        TerminalContext.login((TerminalContext.Context)builder.build());
        try {
            super.publishAuthenticationSuccess(authentication);
        }
        finally {
            TerminalContext.logout((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishAuthenticationFailure(AuthenticationException exception, Authentication authentication) {
        if (!(authentication instanceof WingsBindAuthToken)) {
            super.publishAuthenticationFailure(exception, authentication);
            return;
        }
        WingsBindAuthToken authToken = (WingsBindAuthToken)authentication;
        TerminalContext.Builder builder = new TerminalContext.Builder().locale(LocaleContextHolder.getLocale()).timeZone(LocaleContextHolder.getTimeZone()).authType(authToken.getAuthType()).username(authToken.getName()).guest();
        this.buildTerminal(builder, authentication);
        TerminalContext.login((TerminalContext.Context)builder.build());
        try {
            super.publishAuthenticationFailure(exception, authentication);
        }
        finally {
            TerminalContext.logout((boolean)false);
        }
    }

    private void buildTerminal(TerminalContext.Builder builder, Authentication authentication) {
        Object details = authentication.getDetails();
        if (details instanceof WingsAuthDetails) {
            WingsAuthDetails wad = (WingsAuthDetails)details;
            builder.terminal(TerminalSecurityAttribute.AuthDetails, (Object)wad);
            Map<String, String> metaData = wad.getMetaData();
            builder.terminal(TerminalAttribute.TerminalAddr, (Object)metaData.get("AuthAddr"));
            builder.terminal(TerminalAttribute.TerminalAgent, (Object)metaData.get("AuthAgent"));
        } else if (details instanceof WebAuthenticationDetails) {
            WebAuthenticationDetails wad = (WebAuthenticationDetails)details;
            builder.terminal(TerminalAttribute.TerminalAddr, (Object)wad.getRemoteAddress());
        }
    }
}

