/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.security.impl;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import pro.fessional.wings.slardar.security.WingsUserDetails;
import pro.fessional.wings.slardar.security.bind.WingsBindAuthToken;
import pro.fessional.wings.slardar.security.impl.ComboWingsAuthCheckService;

public abstract class AbstractAuthPermCheckCombo
implements ComboWingsAuthCheckService.Combo {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean check(WingsUserDetails userDetails, WingsBindAuthToken authentication) {
        Collection<String> permit = this.requirePermit(userDetails, authentication);
        if (permit == null || permit.isEmpty()) {
            return true;
        }
        Set all = userDetails.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
        for (String s : permit) {
            if (!all.contains(s)) continue;
            return true;
        }
        this.log.debug("reject login, require any permit {}", permit);
        return false;
    }

    protected abstract Collection<String> requirePermit(WingsUserDetails var1, WingsBindAuthToken var2);
}

