/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.security.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import pro.fessional.mirana.func.Dcl;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.slardar.security.WingsUserDetailsService;

public class ComboWingsUserDetailsService
implements WingsUserDetailsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComboWingsUserDetailsService.class);
    private final List<Combo<?>> combos = new ArrayList();
    private final Dcl<Void> dclCombos = Dcl.of(() -> this.combos.sort(Comparator.comparingInt(Ordered::getOrder)));

    @Override
    @NotNull
    public UserDetails loadUserByUsername(String username, @NotNull Enum<?> authType, @Nullable WingsAuthDetails authDetail) throws UsernameNotFoundException {
        this.dclCombos.runIfDirty();
        UserDetails userDetails = null;
        for (Combo<?> combo : this.combos) {
            userDetails = (UserDetails)combo.loadOrNull(username, authType, authDetail);
            if (userDetails == null) continue;
            log.debug("loadUserByUsername by combo={}", combo.getClass());
            break;
        }
        if (userDetails != null) {
            for (Combo<?> combo : this.combos) {
                userDetails = combo.postAudit(userDetails, username, authType, authDetail);
                if (userDetails != null) continue;
                log.debug("postAudit deny by combo={}", combo.getClass());
                break;
            }
        }
        if (userDetails == null) {
            throw new UsernameNotFoundException("failed load user-details, username=" + username + ", auth-type=" + String.valueOf(authType));
        }
        return userDetails;
    }

    public void add(Combo<?> source) {
        if (source == null) {
            return;
        }
        this.combos.add(source);
        this.dclCombos.setDirty();
    }

    public void addAll(Collection<? extends Combo<?>> source) {
        if (source == null) {
            return;
        }
        this.combos.addAll(source);
        this.dclCombos.setDirty();
    }

    public static interface Combo<T extends UserDetails>
    extends Ordered {
        @Nullable
        default public T loadOrNull(String username, @NotNull Enum<?> authType, @Nullable WingsAuthDetails authDetail) {
            return null;
        }

        @Nullable
        default public UserDetails postAudit(@NotNull UserDetails useDetail, String username, @NotNull Enum<?> authType, @Nullable WingsAuthDetails authDetail) {
            return useDetail;
        }
    }
}

