/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.servlet.response;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.WillClose;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.util.UriComponentsBuilder;
import pro.fessional.mirana.bits.Base64;
import pro.fessional.mirana.io.Zipper;
import pro.fessional.mirana.pain.IORuntimeException;
import pro.fessional.mirana.text.StringTemplate;
import pro.fessional.wings.slardar.concur.WingsCaptchaHelper;
import pro.fessional.wings.slardar.jackson.JacksonHelper;
import pro.fessional.wings.slardar.servlet.ContentTypeHelper;
import pro.fessional.wings.slardar.servlet.stream.ReuseStreamResponseWrapper;

public class ResponseHelper {
    @NotNull
    public static String getDownloadContentType(String fileName) {
        return ContentTypeHelper.findByFileName(fileName, "application/octet-stream");
    }

    @NotNull
    public static String getDownloadContentDisposition(@Nullable String fileName) {
        StringBuilder dis = new StringBuilder("attachment;filename=");
        if (fileName == null) {
            dis.append("download-file");
        } else {
            dis.append(fileName);
            String enc = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
            dis.append(";filename*=UTF-8''").append(enc);
        }
        return dis.toString();
    }

    public static void setDownloadContentType(@NotNull HttpServletResponse response, @Nullable String fileName) {
        response.setContentType(ResponseHelper.getDownloadContentType(fileName));
    }

    public static void setDownloadContentDisposition(@NotNull HttpServletResponse response, @Nullable String fileName) {
        response.setHeader("Content-Disposition", ResponseHelper.getDownloadContentDisposition(fileName));
    }

    public static void downloadFile(@NotNull HttpServletResponse response, @Nullable String fileName, @WillClose @NotNull InputStream stream) {
        try {
            OutputStream outputStream = ResponseHelper.downloadFile(response, fileName);
            IOUtils.copy((InputStream)stream, (OutputStream)outputStream, (int)1024);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream, null);
        }
    }

    public static OutputStream downloadFile(@NotNull HttpServletResponse response, @Nullable String fileName) throws IOException {
        ResponseHelper.setDownloadContentType(response, fileName);
        ResponseHelper.setDownloadContentDisposition(response, fileName);
        return response.getOutputStream();
    }

    public static void downloadFile(@NotNull HttpServletResponse response, @NotNull File file) {
        ResponseHelper.downloadFile(response, file.getName(), new FileInputStream(file));
    }

    public static void downloadFileWithZip(@NotNull HttpServletResponse response, @WillClose @NotNull Map<String, InputStream> files, @Nullable String fileName) {
        if (fileName == null) {
            fileName = "download.zip";
        }
        try {
            response.setContentType("application/zip");
            ResponseHelper.setDownloadContentDisposition(response, fileName);
            Zipper.zip((OutputStream)response.getOutputStream(), files);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        finally {
            for (InputStream is : files.values()) {
                IOUtils.closeQuietly((Closeable)is, null);
            }
        }
    }

    public static void previewPDF(@NotNull HttpServletResponse response, @Nullable String fileName, @WillClose @NotNull InputStream stream) {
        String contentType = ResponseHelper.getDownloadContentType(fileName);
        if (!"application/pdf".equals(contentType)) {
            throw new IllegalArgumentException("The parameter 'fileName' must be a pdf file");
        }
        response.setContentType(contentType);
        StringBuilder disposition = new StringBuilder("inline;");
        if (fileName != null) {
            disposition.append("filename=\"").append(URLEncoder.encode(fileName, StandardCharsets.UTF_8)).append("\"");
        }
        response.setHeader("Content-Disposition", disposition.toString());
        try {
            IOUtils.copy((InputStream)stream, (OutputStream)response.getOutputStream(), (int)1024);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream, null);
        }
    }

    public static void showCaptcha(HttpServletResponse response, String code) {
        try (ServletOutputStream out = response.getOutputStream();){
            response.setDateHeader("Expires", 0L);
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
            response.addHeader("Cache-Control", "post-check=0, pre-check=0");
            response.setHeader("Pragma", "no-cache");
            response.setContentType("image/jpeg");
            BufferedImage bi = WingsCaptchaHelper.createImage(code);
            ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)out);
            out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showCaptcha(HttpServletResponse response, String code, String fmt) {
        if (fmt == null) {
            ResponseHelper.showCaptcha(response, code);
            return;
        }
        try (ServletOutputStream out = response.getOutputStream();){
            response.setDateHeader("Expires", 0L);
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
            response.addHeader("Cache-Control", "post-check=0, pre-check=0");
            response.setHeader("Pragma", "no-cache");
            response.setContentType("text/plain");
            BufferedImage bi = WingsCaptchaHelper.createImage(code);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "jpg", bos);
            byte[] bytes = bos.toByteArray();
            String b64 = Base64.encode((byte[])bytes, (boolean)false);
            String data = StringTemplate.dyn((String)fmt).bindStr("{base64}", (Object)b64).toString();
            out.write(data.getBytes());
            out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void bothHeadCookie(HttpServletResponse response, String key, String value, int second) {
        response.setHeader(key, value);
        Cookie cookie = new Cookie(key, value);
        cookie.setMaxAge(second);
        response.addCookie(cookie);
    }

    public static void writeBodyUtf8(HttpServletResponse response, String body) {
        try {
            response.getOutputStream().write(body.getBytes(StandardCharsets.UTF_8));
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static InputStream tryCachingOutputStream(ServletResponse response) {
        ReuseStreamResponseWrapper inf = ReuseStreamResponseWrapper.infer(response);
        if (inf != null && inf.cachingOutputStream(true)) {
            return inf.getContentInputStream();
        }
        return null;
    }

    public static void renderModelAndView(ModelAndView mav, HttpServletResponse res, HttpServletRequest req) {
        View view;
        HttpStatusCode status = mav.getStatus();
        if (status != null) {
            res.setStatus(status.value());
        }
        if ((view = mav.getView()) != null) {
            try {
                view.render(mav.getModel(), req, res);
            }
            catch (Exception e) {
                throw new IORuntimeException((Throwable)e);
            }
        }
    }

    @NotNull
    public static ResponseEntity<String> flatResponse(Map<String, ?> data, String accept, String uri) {
        if (StringUtils.equals((CharSequence)accept, (CharSequence)"application/xml")) {
            String str = JacksonHelper.string(data, (boolean)false);
            return ResponseEntity.ok((Object)str);
        }
        if (uri != null && !StringUtils.equals((CharSequence)accept, (CharSequence)"application/json")) {
            UriComponentsBuilder bd = UriComponentsBuilder.fromHttpUrl((String)uri);
            for (Map.Entry<String, ?> en : data.entrySet()) {
                bd.queryParam(en.getKey(), new Object[]{en.getValue()});
            }
            String url = bd.build().toUriString();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header("Location", new String[]{url})).build();
        }
        String str = JacksonHelper.string(data, (boolean)true);
        return ResponseEntity.ok((Object)str);
    }
}

