/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.session;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import pro.fessional.wings.slardar.context.SecurityContextUtil;
import pro.fessional.wings.slardar.security.WingsUserDetails;

public interface WingsSessionHelper {
    public static final String UserIdKey = "userId";
    public static final String ExpiredKey = "WingsSession.EXPIRED";

    default public long getUserId(@NotNull Session session) {
        WingsUserDetails dtl;
        Long uid = (Long)session.getAttribute(UserIdKey);
        if (uid != null) {
            return uid;
        }
        SecurityContext ctx = this.getSecurityContext(session);
        if (ctx != null && (dtl = SecurityContextUtil.getUserDetails(ctx.getAuthentication())) != null) {
            return dtl.getUserId();
        }
        return -1L;
    }

    default public boolean isExpired(@NotNull Session session) {
        Object obj = session.getAttribute(ExpiredKey);
        if (obj == null) {
            return false;
        }
        if (Boolean.TRUE.equals(obj)) {
            return true;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return "true".equalsIgnoreCase(str);
        }
        return false;
    }

    @Nullable
    default public SecurityContext getSecurityContext(@NotNull Session session) {
        return (SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT");
    }

    @NotNull
    public List<MapSession> findByUserId(Long var1);

    public boolean dropSession(String var1);
}

