/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pro.fessional.wings.silencer.encrypt.SecretProvider;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.servlet.cookie.WingsCookieFilter;
import pro.fessional.wings.slardar.servlet.cookie.WingsCookieInterceptor;
import pro.fessional.wings.slardar.servlet.cookie.impl.WingsCookieInterceptorImpl;
import pro.fessional.wings.slardar.spring.prop.SlardarCookieProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled(abs="wings.enabled.slardar.cookie", value=false)
public class SlardarCookieConfiguration {
    private static final Log log = LogFactory.getLog(SlardarCookieConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public WingsCookieInterceptorImpl wingsCookieInterceptor(SlardarCookieProp slardarCookieProp, SecretProvider secretProvider) {
        Boolean k;
        String aesKey = secretProvider.tryGet("cookie");
        if (aesKey != null && aesKey.length() > 5) {
            log.info((Object)("SlardarWebmvc spring-bean wingsCookieInterceptor, key=" + aesKey.substring(0, 5) + "..., len=" + aesKey.length()));
        } else {
            log.warn((Object)"SlardarWebmvc spring-bean wingsCookieInterceptor, no key");
        }
        WingsCookieInterceptorImpl interceptor = new WingsCookieInterceptorImpl(aesKey);
        interceptor.setPrefix(slardarCookieProp.getPrefix());
        interceptor.setCoder(slardarCookieProp.getCoder());
        interceptor.addAlias(slardarCookieProp.getAlias());
        interceptor.addCodes(WingsCookieInterceptor.Coder.Nop, slardarCookieProp.getNop());
        interceptor.addCodes(WingsCookieInterceptor.Coder.B64, slardarCookieProp.getB64());
        interceptor.addCodes(WingsCookieInterceptor.Coder.Aes, slardarCookieProp.getAes());
        for (Map.Entry<Boolean, Set<String>> entry : slardarCookieProp.getHttpOnly().entrySet()) {
            k = entry.getKey();
            for (String s : entry.getValue()) {
                interceptor.addHttpOnly(s, k);
            }
        }
        for (Map.Entry<Boolean, Set<String>> entry : slardarCookieProp.getSecure().entrySet()) {
            k = entry.getKey();
            for (String s : entry.getValue()) {
                interceptor.addSecure(s, k);
            }
        }
        for (Map.Entry<Object, Set<String>> entry : slardarCookieProp.getDomain().entrySet()) {
            interceptor.addDomain((String)entry.getKey(), (Collection<String>)entry.getValue());
        }
        for (Map.Entry<Object, Set<String>> entry : slardarCookieProp.getPath().entrySet()) {
            interceptor.addPath((String)entry.getKey(), (Collection<String>)entry.getValue());
        }
        return interceptor;
    }

    @Bean
    @ConditionalWingsEnabled
    public WingsCookieFilter wingsCookieFilter(WingsCookieInterceptor wingsCookieInterceptor) {
        log.info((Object)"SlardarWebmvc spring-bean wingsCookieFilter");
        return new WingsCookieFilter(wingsCookieInterceptor);
    }
}

