/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.concur.impl.DebounceInterceptor;
import pro.fessional.wings.slardar.servlet.response.view.PlainTextView;
import pro.fessional.wings.slardar.spring.prop.SlardarDebounceProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled(abs="wings.enabled.slardar.debounce")
public class SlardarDebounceConfiguration {
    private static final Log log = LogFactory.getLog(SlardarDebounceConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public DebounceInterceptor debounceInterceptor(SlardarDebounceProp debounceProp) {
        int cap = debounceProp.getCapacity();
        int max = debounceProp.getMaxWait();
        log.info((Object)("SlardarWebmvc spring-bean debounceInterceptor, capacity=" + cap + ", max-wait=" + max));
        ModelAndView mav = new ModelAndView();
        PlainTextView pv = new PlainTextView(debounceProp.getContentType(), debounceProp.getResponseBody());
        mav.setStatus((HttpStatusCode)HttpStatus.valueOf((int)debounceProp.getHttpStatus()));
        mav.setView((View)pv);
        return new DebounceInterceptor(cap, max, mav);
    }
}

