/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import pro.fessional.mirana.best.DummyBlock;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.servlet.filter.WingsOverloadFilter;
import pro.fessional.wings.slardar.servlet.resolver.WingsRemoteResolver;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled(value=false)
@ConditionalOnClass(value={Filter.class})
@Deprecated
public class SlardarOverloadConfiguration {
    private final Log log = LogFactory.getLog(SlardarOverloadConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public WingsOverloadFilter.FallBack overloadFallback(WingsOverloadFilter.Config config) {
        this.log.info((Object)"SlardarWebmvc spring-bean overloadFallback");
        return (request, response) -> {
            try {
                if (response instanceof HttpServletResponse) {
                    HttpServletResponse res = (HttpServletResponse)response;
                    res.setStatus(config.getFallbackCode());
                }
                PrintWriter writer = response.getWriter();
                writer.println(config.getFallbackBody());
                writer.flush();
            }
            catch (IOException e) {
                DummyBlock.ignore((Throwable)e);
            }
        };
    }

    @Bean
    @ConditionalWingsEnabled
    public WingsOverloadFilter wingsOverloadFilter(WingsOverloadFilter.Config config, WingsOverloadFilter.FallBack fallBack, WingsRemoteResolver resolver) {
        this.log.info((Object)"SlardarWebmvc spring-bean wingsOverloadFilter");
        return new WingsOverloadFilter(fallBack, config, resolver);
    }

    @Component
    @Order
    @ConditionalWingsEnabled
    public class SafelyShutdown
    implements ApplicationListener<ContextClosedEvent> {
        public void onApplicationEvent(@NotNull ContextClosedEvent event) {
            WingsOverloadFilter overloadFilter = (WingsOverloadFilter)event.getApplicationContext().getBean(WingsOverloadFilter.class);
            overloadFilter.setRequestCapacity(Integer.MIN_VALUE);
            SlardarOverloadConfiguration.this.log.warn((Object)("SlardarWebmvc shutting down, deny new request, current=" + overloadFilter.getRequestProcess()));
            long breaks = 20000L;
            long step = 100L;
            while (overloadFilter.getRequestProcess() > 0 && breaks > 0L) {
                try {
                    Thread.sleep(step);
                    breaks -= step;
                }
                catch (InterruptedException e) {
                    DummyBlock.ignore((Throwable)e);
                }
            }
            SlardarOverloadConfiguration.this.log.warn((Object)"SlardarWebmvc safely shutting down, no request in processing");
        }
    }
}

