/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.webmvc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.mirana.time.StopWatch;
import pro.fessional.wings.silencer.watch.Watches;
import pro.fessional.wings.slardar.constants.SlardarServletConst;
import pro.fessional.wings.slardar.webmvc.AutoRegisterInterceptor;

public class SlowResponseInterceptor
implements AutoRegisterInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlowResponseInterceptor.class);
    public static final int ORDER = -9999000;
    private int order = -9999000;
    private long thresholdMillis = -1L;
    private BiConsumer<Long, HttpServletRequest> costAndReqConsumer = (c, r) -> log.warn("SLOW-RES cost={}ms, uri={}", c, (Object)r.getRequestURI());

    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) {
        if (this.thresholdMillis < 0L) {
            return true;
        }
        StopWatch.Watch watch = Watches.acquire((String)request.getRequestURI());
        request.setAttribute((String)SlardarServletConst.AttrStopWatch.value, (Object)watch);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler, Exception ex) {
        StopWatch.Watch watch = (StopWatch.Watch)request.getAttribute((String)SlardarServletConst.AttrStopWatch.value);
        if (watch == null) {
            return;
        }
        watch.close();
        long cost = watch.getElapseMs();
        boolean slow = cost >= this.thresholdMillis;
        try {
            if (slow) {
                this.costAndReqConsumer.accept(cost, request);
            }
            Watches.release((boolean)true, (String)(slow ? "SlowResponseInterceptor" : null));
        }
        catch (Throwable throwable) {
            Watches.release((boolean)true, (String)(slow ? "SlowResponseInterceptor" : null));
            throw throwable;
        }
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public long getThresholdMillis() {
        return this.thresholdMillis;
    }

    @Generated
    public BiConsumer<Long, HttpServletRequest> getCostAndReqConsumer() {
        return this.costAndReqConsumer;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setThresholdMillis(long thresholdMillis) {
        this.thresholdMillis = thresholdMillis;
    }

    @Generated
    public void setCostAndReqConsumer(BiConsumer<Long, HttpServletRequest> costAndReqConsumer) {
        this.costAndReqConsumer = costAndReqConsumer;
    }
}

