/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.webmvc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import pro.fessional.wings.slardar.servlet.response.view.PlainTextView;
import pro.fessional.wings.slardar.webmvc.SimpleResponse;

public abstract class WingsExceptionResolver<T extends Exception>
implements HandlerExceptionResolver,
Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WingsExceptionResolver.class);
    private int order = Integer.MAX_VALUE;
    protected final Class<?> acceptClass;

    protected WingsExceptionResolver() {
        Type superClass = this.getClass().getGenericSuperclass();
        if (superClass instanceof Class) {
            throw new IllegalArgumentException("Internal error: TypeReference constructed without actual type information");
        }
        this.acceptClass = (Class)((ParameterizedType)superClass).getActualTypeArguments()[0];
        log.info("WingsExceptionResolver={}, Exception={}", (Object)this.getClass().getName(), this.acceptClass);
    }

    public ModelAndView resolveException(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @Nullable Object handler, @NotNull Exception ex) {
        if (this.acceptClass.isInstance(ex)) {
            SimpleResponse body = this.resolve(ex, request);
            if (body == null) {
                return null;
            }
            ModelAndView mav = new ModelAndView();
            PlainTextView pv = new PlainTextView(body.getContentType(), body.getResponseBody());
            mav.setStatus((HttpStatusCode)HttpStatus.valueOf((int)body.getHttpStatus()));
            mav.setView((View)pv);
            return mav;
        }
        return null;
    }

    @Nullable
    protected abstract SimpleResponse resolve(@NotNull T var1, @NotNull HttpServletRequest var2);

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public Class<?> getAcceptClass() {
        return this.acceptClass;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

