/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.autodto;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.anti.BeanVisitor;
import pro.fessional.wings.slardar.autozone.AutoTimeZone;
import pro.fessional.wings.slardar.autozone.AutoZoneType;
import pro.fessional.wings.slardar.autozone.AutoZoneUtil;

public class AutoZoneVisitor
extends BeanVisitor.ContainerVisitor {
    private final Supplier<ZoneId> clientZoneSupplier;
    private final boolean isRequest;

    public boolean cares(@NotNull Field field, @NotNull Annotation[] annos) {
        for (Annotation an : annos) {
            if (!AutoTimeZone.class.equals(an.annotationType())) continue;
            return ((AutoTimeZone)an).value() != AutoZoneType.Off;
        }
        return false;
    }

    @Nullable
    protected Object amendValue(@NotNull Field field, @NotNull Annotation[] annos, @Nullable Object obj) {
        AutoZoneType autoType = AutoZoneType.Off;
        for (Annotation an : annos) {
            if (!AutoTimeZone.class.equals(an.annotationType())) continue;
            autoType = ((AutoTimeZone)an).value();
            break;
        }
        if (autoType == AutoZoneType.Off) {
            return obj;
        }
        if (obj instanceof LocalDateTime) {
            if (this.isRequest) {
                return AutoZoneUtil.autoLocalRequest((LocalDateTime)obj, autoType, this.clientZoneSupplier);
            }
            return AutoZoneUtil.autoLocalResponse((LocalDateTime)obj, autoType, this.clientZoneSupplier);
        }
        if (obj instanceof ZonedDateTime) {
            if (this.isRequest) {
                return AutoZoneUtil.autoZonedRequest((ZonedDateTime)obj, autoType, this.clientZoneSupplier);
            }
            return AutoZoneUtil.autoZonedResponse((ZonedDateTime)obj, autoType, this.clientZoneSupplier);
        }
        if (obj instanceof OffsetDateTime) {
            if (this.isRequest) {
                return AutoZoneUtil.autoOffsetRequest((OffsetDateTime)obj, autoType, this.clientZoneSupplier);
            }
            return AutoZoneUtil.autoOffsetResponse((OffsetDateTime)obj, autoType, this.clientZoneSupplier);
        }
        return obj;
    }

    public AutoZoneVisitor(Supplier<ZoneId> clientZoneSupplier, boolean isRequest) {
        this.clientZoneSupplier = clientZoneSupplier;
        this.isRequest = isRequest;
    }
}

