/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.autozone;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.time.DateLocaling;
import pro.fessional.mirana.time.DateParser;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.slardar.autozone.AutoZoneType;

public class AutoZoneUtil {
    @NotNull
    public static LocalDateTime autoLocalRequest(@NotNull TemporalAccessor dateTime, @NotNull AutoZoneType autoType, @NotNull Supplier<ZoneId> client) {
        if (autoType == AutoZoneType.Off) {
            return (LocalDateTime)dateTime.query(DateParser.QueryDateTime);
        }
        ZonedDateTime zdt = AutoZoneUtil.autoZonedRequest(dateTime, autoType, client);
        return zdt.toLocalDateTime();
    }

    @NotNull
    public static ZonedDateTime autoZonedRequest(@NotNull TemporalAccessor dateTime, @NotNull AutoZoneType autoType, @NotNull Supplier<ZoneId> client) {
        ZonedDateTime zdt = DateParser.parseZoned((TemporalAccessor)dateTime, (ZoneId)client.get());
        if (autoType == AutoZoneType.Auto || autoType == AutoZoneType.System) {
            return zdt.withZoneSameInstant(ThreadNow.sysZoneId());
        }
        return zdt;
    }

    @NotNull
    public static OffsetDateTime autoOffsetRequest(@NotNull TemporalAccessor dateTime, @NotNull AutoZoneType autoType, @NotNull Supplier<ZoneId> client) {
        ZonedDateTime zdt = AutoZoneUtil.autoZonedRequest(dateTime, autoType, client);
        return zdt.toOffsetDateTime();
    }

    @NotNull
    public static LocalDateTime autoLocalResponse(@NotNull LocalDateTime dateTime, @NotNull AutoZoneType autoType, @NotNull Supplier<ZoneId> client) {
        if (autoType == AutoZoneType.Auto || autoType == AutoZoneType.Client) {
            return DateLocaling.useLdt((LocalDateTime)dateTime, (ZoneId)client.get());
        }
        return dateTime;
    }

    @NotNull
    public static ZonedDateTime autoZonedResponse(@NotNull ZonedDateTime dateTime, @NotNull AutoZoneType autoType, @NotNull Supplier<ZoneId> client) {
        if (autoType == AutoZoneType.Auto || autoType == AutoZoneType.Client) {
            return dateTime.withZoneSameInstant(client.get());
        }
        if (autoType == AutoZoneType.System) {
            return dateTime.withZoneSameInstant(ThreadNow.sysZoneId());
        }
        return dateTime;
    }

    @NotNull
    public static OffsetDateTime autoOffsetResponse(@NotNull OffsetDateTime dateTime, @NotNull AutoZoneType autoType, @NotNull Supplier<ZoneId> client) {
        if (autoType == AutoZoneType.Auto || autoType == AutoZoneType.Client) {
            return dateTime.atZoneSameInstant(client.get()).toOffsetDateTime();
        }
        if (autoType == AutoZoneType.System) {
            return dateTime.atZoneSameInstant(ThreadNow.sysZoneId()).toOffsetDateTime();
        }
        return dateTime;
    }
}

