/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.autozone.json;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import pro.fessional.mirana.time.DateParser;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.slardar.autozone.AutoTimeZone;
import pro.fessional.wings.slardar.autozone.AutoZoneAware;
import pro.fessional.wings.slardar.autozone.AutoZoneType;

public class JacksonZonedDateTimeDeserializer
extends InstantDeserializer<ZonedDateTime>
implements AutoZoneAware {
    private final List<DateTimeFormatter> formats;
    private AutoZoneType autoZone;

    public JacksonZonedDateTimeDeserializer(DateTimeFormatter formatter, List<DateTimeFormatter> formats, boolean auto) {
        this(formatter, formats, AutoZoneType.valueOf(auto));
    }

    public JacksonZonedDateTimeDeserializer(DateTimeFormatter formatter, List<DateTimeFormatter> formats, AutoZoneType auto) {
        super(ZonedDateTime.class, formatter, temporal -> DateParser.parseZoned((TemporalAccessor)temporal, (ZoneId)ThreadNow.sysZoneId()), a -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> ZonedDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), (zonedDateTime, zoneId) -> zonedDateTime, false);
        this.formats = formats;
        this.autoZone = auto;
    }

    public ZonedDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        TemporalAccessor tma = DateParser.parseTemporal((CharSequence)parser.getText(), this.formats, (boolean)true);
        if (tma != null) {
            return this.autoZonedRequest(tma, this.autoZone);
        }
        return (ZonedDateTime)super.deserialize(parser, context);
    }

    protected JacksonZonedDateTimeDeserializer(JacksonZonedDateTimeDeserializer jacksonZonedDeserializer, Boolean leniency, List<DateTimeFormatter> formats, AutoZoneType auto) {
        super((InstantDeserializer)jacksonZonedDeserializer, leniency);
        this.formats = formats;
        this.autoZone = auto;
    }

    protected JacksonZonedDateTimeDeserializer withDateFormat(DateTimeFormatter dtf) {
        if (dtf == this._formatter) {
            return this;
        }
        ArrayList<DateTimeFormatter> fts = new ArrayList<DateTimeFormatter>(this.formats.size());
        fts.add(dtf);
        fts.addAll(this.formats);
        return new JacksonZonedDateTimeDeserializer(dtf, fts, this.autoZone);
    }

    protected JacksonZonedDateTimeDeserializer withLeniency(Boolean leniency) {
        return new JacksonZonedDateTimeDeserializer(this, leniency, this.formats, this.autoZone);
    }

    protected JacksonZonedDateTimeDeserializer withShape(JsonFormat.Shape shape) {
        return this;
    }

    public JacksonZonedDateTimeDeserializer createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        AutoTimeZone anno;
        JacksonZonedDateTimeDeserializer dsr = (JacksonZonedDateTimeDeserializer)super.createContextual(ctxt, property);
        if (property != null && (anno = (AutoTimeZone)property.getAnnotation(AutoTimeZone.class)) != null) {
            dsr.autoZone = anno.value();
        }
        return dsr;
    }
}

