/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.autozone.spring;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import pro.fessional.mirana.time.DateParser;
import pro.fessional.wings.slardar.autozone.AutoTimeZone;
import pro.fessional.wings.slardar.autozone.AutoZoneAware;
import pro.fessional.wings.slardar.autozone.AutoZoneType;
import pro.fessional.wings.slardar.autozone.spring.DateTimeFormatSupport;

public class String2ZonedDateTimeConverter
extends DateTimeFormatSupport
implements AutoZoneAware {
    private final List<DateTimeFormatter> formats;
    private final AutoZoneType autoZone;
    private final Set<GenericConverter.ConvertiblePair> pairs = Collections.singleton(new GenericConverter.ConvertiblePair(String.class, ZonedDateTime.class));

    public String2ZonedDateTimeConverter(List<DateTimeFormatter> formats, boolean auto) {
        this(formats, AutoZoneType.valueOf(auto));
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.pairs;
    }

    public Object convert(Object source, @NotNull TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
        DateTimeFormatter fmt = this.getFormatter(targetType);
        List<DateTimeFormatter> fmts = fmt == null ? this.formats : Collections.singletonList(fmt);
        TemporalAccessor tma = DateParser.parseTemporal((CharSequence)((String)source), fmts, (boolean)true);
        if (tma != null) {
            AutoTimeZone anno = (AutoTimeZone)targetType.getAnnotation(AutoTimeZone.class);
            return this.autoZonedRequest(tma, anno == null ? this.autoZone : anno.value());
        }
        return null;
    }

    public String2ZonedDateTimeConverter(List<DateTimeFormatter> formats, AutoZoneType autoZone) {
        this.formats = formats;
        this.autoZone = autoZone;
    }
}

