/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.autozone.spring;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import pro.fessional.wings.slardar.autozone.AutoTimeZone;
import pro.fessional.wings.slardar.autozone.AutoZoneAware;
import pro.fessional.wings.slardar.autozone.AutoZoneType;
import pro.fessional.wings.slardar.autozone.spring.DateTimeFormatSupport;

public class ZonedDateTime2StringConverter
extends DateTimeFormatSupport
implements AutoZoneAware {
    private final DateTimeFormatter format;
    private final AutoZoneType autoZone;
    private final Set<GenericConverter.ConvertiblePair> pairs = Collections.singleton(new GenericConverter.ConvertiblePair(ZonedDateTime.class, String.class));

    public ZonedDateTime2StringConverter(DateTimeFormatter format, boolean auto) {
        this(format, AutoZoneType.valueOf(auto));
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.pairs;
    }

    public Object convert(Object source, @NotNull TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
        AutoTimeZone anno = (AutoTimeZone)targetType.getAnnotation(AutoTimeZone.class);
        ZonedDateTime zdt = this.autoZonedResponse((ZonedDateTime)source, anno == null ? this.autoZone : anno.value());
        DateTimeFormatter fmt = this.getFormatter(targetType);
        return zdt.format(fmt == null ? this.format : fmt);
    }

    public ZonedDateTime2StringConverter(DateTimeFormatter format, AutoZoneType autoZone) {
        this.format = format;
        this.autoZone = autoZone;
    }
}

