/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.cache;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public interface WingsCache {
    public static final String Joiner = "~";
    public static final String Extend = "!";
    public static final String Wildcard = "*";

    public static interface State {
        @NotNull
        public Map<String, Integer> statsCacheSize();

        @NotNull
        public Set<Object> statsCacheKeys(String var1);
    }

    public static class Level {
        public static final String Forever = "program~";
        public static final String General = "general~";
        public static final String Service = "service~";
        public static final String Session = "session~";

        public static String forever(String ... part) {
            return Forever + String.join((CharSequence)WingsCache.Joiner, part);
        }

        public static String general(String ... part) {
            return General + String.join((CharSequence)WingsCache.Joiner, part);
        }

        public static String service(String ... part) {
            return Service + String.join((CharSequence)WingsCache.Joiner, part);
        }

        public static String session(String ... part) {
            return Session + String.join((CharSequence)WingsCache.Joiner, part);
        }
    }

    public static class Resolver {
        public static final String Suffix = "Resolver";
        public static final String Memory = "MemoryCacheManagerResolver";
        public static final String Server = "ServerCacheManagerResolver";
    }

    public static class Manager {
        public static final String Memory = "MemoryCacheManager";
        public static final String Server = "ServerCacheManager";
    }

    public static class Naming {
        private static final AtomicLong Counter = new AtomicLong(1L);

        @NotNull
        public static String use(@NotNull Class<?> owner, @NotNull String use) {
            return owner.getName() + WingsCache.Joiner + use + "-" + Counter.getAndIncrement();
        }

        @NotNull
        public static String use(@NotNull Class<?> clz, @NotNull Class<?> use) {
            return Naming.use(clz, use.getName().substring(use.getPackageName().length() + 1));
        }

        public static String join(String ... part) {
            return String.join((CharSequence)WingsCache.Joiner, part);
        }

        @NotNull
        public static String wildcard(String level) {
            return level + "~*";
        }

        public static boolean inLevel(String name, String level) {
            if (name == null || level == null) {
                return false;
            }
            int len = level.length();
            return name.regionMatches(true, 0, level, 0, len) && name.regionMatches(true, len, WingsCache.Joiner, 0, WingsCache.Joiner.length());
        }
    }
}

