/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.cache.cache2k;

import java.util.concurrent.Callable;
import org.cache2k.Cache;
import org.cache2k.extra.spring.SpringCache2kCache;
import org.jetbrains.annotations.NotNull;
import org.springframework.cache.Cache;
import pro.fessional.wings.slardar.cache.cache2k.WingsCache2k;

public class NullsCache2k
extends SpringCache2kCache {
    private final Cache<Object, Object> nulls;

    public NullsCache2k(Cache<Object, Object> cache, int size, int live) {
        super(cache);
        this.nulls = size > 0 ? WingsCache2k.builder(NullsCache2k.class, "nulls", size, live, 0).build() : null;
    }

    public Cache.ValueWrapper get(@NotNull Object key) {
        if (this.nulls != null && this.nulls.get(key) != null) {
            return null;
        }
        return super.get(key);
    }

    public <T> T get(@NotNull Object key, Class<T> type) {
        if (this.nulls != null && this.nulls.get(key) != null) {
            return null;
        }
        return (T)super.get(key, type);
    }

    public <T> T get(@NotNull Object key, @NotNull Callable<T> valueLoader) {
        if (this.nulls != null && this.nulls.get(key) != null) {
            return null;
        }
        Object value = super.get(key, valueLoader);
        if (value == null && this.nulls != null) {
            this.nulls.put(key, (Object)Boolean.TRUE);
        }
        return (T)value;
    }

    public void put(@NotNull Object key, Object value) {
        if (value == null) {
            if (this.nulls != null) {
                this.nulls.put(key, (Object)Boolean.TRUE);
            }
        } else {
            super.put(key, value);
        }
    }

    public void evict(@NotNull Object key) {
        super.evict(key);
        if (this.nulls != null) {
            this.nulls.remove(key);
        }
    }

    public void clear() {
        super.clear();
        if (this.nulls != null) {
            this.nulls.removeAll();
        }
    }
}

