/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.concur;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.cache2k.Cache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.code.LeapCode;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.slardar.cache.cache2k.WingsCache2k;

public class ProgressContext {
    private static final Cache<Object, Bar> Cache = WingsCache2k.builder(ProgressContext.class, "bar", 0, 86400, 0, Object.class, Bar.class).build();
    private static final AtomicLong Counter = new AtomicLong(0L);
    private static final LeapCode Encoder = new LeapCode();

    @Nullable
    public static Bar get(Object key) {
        return key == null ? null : (Bar)Cache.get(key);
    }

    @NotNull
    public static Bar gen(Object key, int second) {
        return ProgressContext.gen(key, ThreadNow.millis(), second);
    }

    @NotNull
    public static Bar gen(Object key, long started, int second) {
        Bar bar = new Bar(ProgressContext.key(started, second), started);
        Cache.mutate((Object)bar.key, entry -> {
            entry.setValue((Object)bar);
            entry.setExpiryTime(entry.getStartTime() + (long)second * 1000L);
        });
        if (key != null) {
            Cache.mutate(key, entry -> {
                entry.setValue((Object)bar);
                entry.setExpiryTime(entry.getStartTime() + (long)second * 1000L);
            });
        }
        return bar;
    }

    @NotNull
    public static String key(long started, int second) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(Encoder.encode26((long)second, 5));
        sb.append('-');
        sb.append(Encoder.encode26(started, 10));
        long cnt = Counter.incrementAndGet();
        while (cnt <= 0L) {
            Counter.set(0L);
            cnt = Counter.incrementAndGet();
        }
        sb.append('-');
        sb.append(Encoder.encode26(cnt, 5));
        return sb.toString();
    }

    public static class Bar {
        private final String key;
        private final long started;
        private volatile long stopped = -1L;
        private volatile int percent = 0;
        private volatile transient Object result = null;
        private volatile transient Object attach = null;
        private volatile transient Throwable error = null;

        public Bar(String key, long started) {
            this.key = key;
            this.started = started;
        }

        public boolean isDone() {
            return this.stopped > 0L;
        }

        public void setPercent(int percent) {
            this.percent = percent;
        }

        public void setAttach(Object attach) {
            this.attach = attach;
        }

        public void fail(Throwable error) {
            this.error = error;
            this.stopped = ThreadNow.millis();
        }

        public void ok(Object result) {
            this.result = result;
            this.stopped = ThreadNow.millis();
            this.percent = 100;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bar bar = (Bar)o;
            return Objects.equals(this.key, bar.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public String toString() {
            return "Bar{key='" + this.key + "', started=" + this.started + ", stopped=" + this.stopped + ", percent=" + this.percent + "}";
        }

        public String getKey() {
            return this.key;
        }

        public long getStarted() {
            return this.started;
        }

        public long getStopped() {
            return this.stopped;
        }

        public int getPercent() {
            return this.percent;
        }

        public Object getResult() {
            return this.result;
        }

        public Object getAttach() {
            return this.attach;
        }

        public Throwable getError() {
            return this.error;
        }
    }
}

