/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.concur.impl;

import com.alibaba.ttl.threadpool.TtlExecutors;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.CachedExpressionEvaluator;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.annotation.Order;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.util.StringUtils;
import pro.fessional.mirana.lock.ArrayKey;
import pro.fessional.mirana.lock.JvmStaticGlobalLock;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.slardar.concur.DoubleKill;
import pro.fessional.wings.slardar.concur.DoubleKillException;
import pro.fessional.wings.slardar.concur.ProgressContext;
import pro.fessional.wings.slardar.context.TerminalContext;

@Aspect
@Order(value=-50000000)
public class DoubleKillAround {
    private static final Logger log = LoggerFactory.getLogger(DoubleKillAround.class);
    private final Evaluator evaluator = new Evaluator();
    protected BeanFactory beanFactory;
    protected Executor asyncExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(pro.fessional.wings.slardar.concur.DoubleKill)")
    public Object doubleKill(ProceedingJoinPoint joinPoint) throws Throwable {
        ProgressContext.Bar bar;
        ArrayKey arrKey;
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        DoubleKill doubleKill = method.getAnnotation(DoubleKill.class);
        Long uid = doubleKill.principal() ? TerminalContext.get(false).getUserId() : -1L;
        Object[] args = joinPoint.getArgs();
        String keyStr = doubleKill.value();
        if (StringUtils.hasText((String)keyStr)) {
            arrKey = new ArrayKey(new Object[]{method, uid, keyStr});
        } else {
            String spelKey = doubleKill.expression();
            if (StringUtils.hasText((String)spelKey)) {
                Root root = new Root(method, args, joinPoint.getTarget());
                EvaluationContext ctx = this.evaluator.createContext(root, this.beanFactory);
                AnnotatedElementKey methodKey = new AnnotatedElementKey((AnnotatedElement)root.method, root.targetClass);
                Object key = this.evaluator.key(spelKey, methodKey, ctx);
                arrKey = new ArrayKey(new Object[]{method, uid, key});
            } else {
                arrKey = args == null || args.length == 0 ? new ArrayKey(new Object[]{method, uid}) : new ArrayKey(new Object[]{method, uid, args});
            }
        }
        long now = ThreadNow.millis();
        Lock lock = JvmStaticGlobalLock.get((Object[])new Object[]{arrKey});
        int ttl = doubleKill.progress();
        if (lock.tryLock()) {
            try {
                bar = ProgressContext.gen(arrKey, now, ttl);
                if (doubleKill.async()) {
                    this.checkTtlExecutor();
                    this.asyncExecutor.execute(() -> {
                        try {
                            this.syncProceed(joinPoint, bar);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                    throw new DoubleKillException(bar.getKey(), bar.getStarted(), now);
                }
                Object object = this.syncProceed(joinPoint, bar);
                return object;
            }
            finally {
                lock.unlock();
            }
        }
        bar = ProgressContext.get(arrKey);
        if (bar == null) {
            throw new DoubleKillException("", 0L);
        }
        throw new DoubleKillException(bar.getKey(), bar.getStarted(), now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTtlExecutor() {
        if (TtlExecutors.isTtlWrapper((Executor)this.asyncExecutor)) {
            return;
        }
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            if (TtlExecutors.isTtlWrapper((Executor)this.asyncExecutor)) {
                return;
            }
            if (this.asyncExecutor == null) {
                log.warn("config default Executors use newWorkStealingPool");
                this.asyncExecutor = Executors.newWorkStealingPool();
            }
            this.asyncExecutor = TtlExecutors.getTtlExecutor((Executor)this.asyncExecutor);
        }
    }

    private Object syncProceed(ProceedingJoinPoint joinPoint, ProgressContext.Bar bar) throws Throwable {
        try {
            Object r = joinPoint.proceed();
            bar.ok(r);
            return r;
        }
        catch (Throwable e) {
            bar.fail(e);
            throw e;
        }
    }

    @Autowired(required=false)
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Autowired
    @Qualifier(value="taskExecutor")
    public void setAsyncExecutor(Executor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    public static class Evaluator
    extends CachedExpressionEvaluator {
        private final Map<CachedExpressionEvaluator.ExpressionKey, Expression> keyCache = new ConcurrentHashMap<CachedExpressionEvaluator.ExpressionKey, Expression>(64);

        public EvaluationContext createContext(Root root, @Nullable BeanFactory beanFactory) {
            MethodBasedEvaluationContext context = new MethodBasedEvaluationContext((Object)root, root.method, root.args, this.getParameterNameDiscoverer());
            if (beanFactory != null) {
                context.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
            }
            return context;
        }

        @Nullable
        public Object key(String keyExpression, AnnotatedElementKey methodKey, EvaluationContext evalContext) {
            return this.getExpression(this.keyCache, methodKey, keyExpression).getValue(evalContext);
        }
    }

    public static class Root {
        private final Method method;
        private final Object[] args;
        private final Object target;
        private final Class<?> targetClass;

        public Root(Method method, Object[] args, Object target) {
            this.method = method;
            this.args = args;
            this.target = target;
            this.targetClass = target.getClass();
        }

        public String getMethodName() {
            return this.method.getName();
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public Object getTarget() {
            return this.target;
        }

        public Class<?> getTargetClass() {
            return this.targetClass;
        }
    }
}

