/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.context;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.cache2k.Cache;
import org.cache2k.config.CacheType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.best.TypedReg;
import pro.fessional.wings.slardar.cache.cache2k.WingsCache2k;

public class AttributeCache<K, V> {
    private static final HashMap<TypedReg<?, ?>, Set<AttributeCache<?, ?>>> Registers = new HashMap();
    private final Cache<K, V> cache;
    private Function<K, V> loader;
    private final Class<?> owner;
    private final TypedReg<K, V> typed;
    private final String name;
    private final int size;
    private final int live;
    private final int idle;

    public AttributeCache(@NotNull Class<?> owner, @NotNull TypedReg<K, V> reg, int max, int ttl, int tti) {
        this(owner, reg, max, ttl, tti, null);
    }

    public AttributeCache(@NotNull Class<?> owner, @NotNull TypedReg<K, V> reg, int max, int ttl, int tti, @Nullable Function<K, V> loader) {
        String use = reg.regType.getName().substring(reg.regType.getPackageName().length() + 1);
        this.cache = WingsCache2k.builder(owner, use, max, ttl, tti).keyType(CacheType.of((Type)reg.keyType)).valueType(CacheType.of((Type)reg.valType)).build();
        this.loader = loader;
        this.owner = owner;
        this.typed = reg;
        this.name = this.cache.getName();
        this.size = Math.max(0, max);
        this.live = Math.max(0, ttl);
        this.idle = Math.max(0, tti);
    }

    public void putAttr(@NotNull K key, @NotNull V value) {
        this.cache.put(key, value);
    }

    public void putAttr(@NotNull K key, @NotNull V value, int ttl) {
        if (ttl > 0) {
            this.cache.mutate(key, entry -> {
                entry.setValue(value);
                entry.setExpiryTime(entry.getStartTime() + (long)ttl * 1000L);
            });
        } else {
            this.cache.put(key, value);
        }
    }

    public void putAttrs(@NotNull Map<K, V> map) {
        this.cache.putAll(map);
    }

    public void putAttrs(@NotNull Map<K, V> map, int ttl) {
        if (ttl > 0) {
            for (Map.Entry en : map.entrySet()) {
                this.cache.mutate(en.getKey(), entry -> {
                    entry.setValue(en.getValue());
                    entry.setExpiryTime(entry.getStartTime() + (long)ttl * 1000L);
                });
            }
        } else {
            this.cache.putAll(map);
        }
    }

    @Contract(value="_,!null->!null")
    public V tryAttr(@NotNull K key, V elze) {
        V obj = this.tryAttr(key, false, 0);
        return obj == null ? elze : obj;
    }

    @Contract(value="_,!null,_->!null")
    public V tryAttr(@NotNull K key, V elze, int ttl) {
        V obj = this.tryAttr(key, false, ttl);
        return obj == null ? elze : obj;
    }

    @NotNull
    public V tryAttr(@NotNull K key) {
        return this.tryAttr(key, true, 0);
    }

    @NotNull
    public V tryAttr(@NotNull K key, int ttl) {
        return this.tryAttr(key, true, ttl);
    }

    @Contract(value="_,true ->!null")
    public V tryAttr(@NotNull K key, boolean notnull) {
        return this.tryAttr(key, notnull, 0);
    }

    @Contract(value="_,true,_ ->!null")
    public V tryAttr(@NotNull K key, boolean notnull, int ttl) {
        Object rst = this.cache.invoke(key, entry -> {
            if (entry.exists()) {
                return entry.getValue();
            }
            Object v = null;
            if (this.loader != null) {
                v = this.loader.apply(key);
                entry.setValue(v);
                if (ttl > 0) {
                    entry.setExpiryTime(entry.getStartTime() + (long)ttl * 1000L);
                }
            }
            return v;
        });
        if (rst == null && notnull) {
            throw new NullPointerException("typed=" + String.valueOf(this.typed) + ",key=" + String.valueOf(key));
        }
        return (V)rst;
    }

    @Nullable
    public V getAttr(@NotNull K key) {
        return (V)this.cache.get(key);
    }

    @NotNull
    public Map<K, V> getAttrs(@NotNull Collection<K> key) {
        return this.cache.getAll(key);
    }

    public void ridAttr(K key) {
        this.cache.remove(key);
    }

    public void ridAttrs(Collection<? extends K> key) {
        if (key == null || key.isEmpty()) {
            return;
        }
        this.cache.removeAll(key);
    }

    public void ridAttrAll() {
        this.cache.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        Set tmp;
        Object object = Registers;
        synchronized (object) {
            tmp = Registers.computeIfAbsent(this.typed, ignore -> new LinkedHashSet());
        }
        object = tmp;
        synchronized (object) {
            tmp.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        Set<AttributeCache<?, ?>> tmp;
        Object object = Registers;
        synchronized (object) {
            tmp = Registers.get(this.typed);
        }
        if (tmp == null) {
            return;
        }
        object = tmp;
        synchronized (object) {
            tmp.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Set<TypedReg<?, ?>> registered() {
        LinkedHashSet tmp;
        HashMap<TypedReg<?, ?>, Set<AttributeCache<?, ?>>> hashMap = Registers;
        synchronized (hashMap) {
            tmp = new LinkedHashSet(Registers.keySet());
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> void forEach(@NotNull TypedReg<K, V> reg, @NotNull Consumer<AttributeCache<K, V>> handle) {
        LinkedHashSet ats;
        Set<AttributeCache<?, ?>> tmp;
        HashMap<TypedReg<?, ?>, Set<AttributeCache<?, ?>>> hashMap = Registers;
        synchronized (hashMap) {
            tmp = Registers.get(reg);
        }
        if (tmp == null) {
            return;
        }
        Set<AttributeCache<?, ?>> set = tmp;
        synchronized (set) {
            ats = new LinkedHashSet(tmp);
        }
        for (AttributeCache attributeCache : ats) {
            handle.accept(attributeCache);
        }
    }

    public void setLoader(Function<K, V> loader) {
        this.loader = loader;
    }

    public Class<?> getOwner() {
        return this.owner;
    }

    public TypedReg<K, V> getTyped() {
        return this.typed;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public int getLive() {
        return this.live;
    }

    public int getIdle() {
        return this.idle;
    }
}

