/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.context;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.best.DummyBlock;
import pro.fessional.mirana.best.TypedKey;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.slardar.context.TerminalContextException;
import pro.fessional.wings.slardar.errcode.AuthnErrorEnum;

public class TerminalContext {
    public static final Context Null = new Context(Long.MIN_VALUE, Locale.getDefault(), TimeZone.getDefault(), Collections.emptyMap(), pro.fessional.mirana.data.Null.Enm, "", Collections.emptySet());
    private static final TransmittableThreadLocal<Context> ContextLocal = new TransmittableThreadLocal();
    private static final ConcurrentHashMap<String, Listener> ContextListeners = new ConcurrentHashMap();
    private static volatile boolean Active;
    @NotNull
    private static volatile TimeZone DefaultTimeZone;
    @NotNull
    private static volatile Locale DefaultLocale;

    public static void initTimeZone(@NotNull TimeZone zoneId) {
        DefaultTimeZone = zoneId;
    }

    public static void initLocale(@NotNull Locale locale) {
        DefaultLocale = locale;
    }

    @NotNull
    public static ZoneId defaultZoneId() {
        return DefaultTimeZone.toZoneId();
    }

    @NotNull
    public static TimeZone defaultTimeZone() {
        return DefaultTimeZone;
    }

    @NotNull
    public static Locale defaultLocale() {
        return DefaultLocale;
    }

    @NotNull
    public static ZoneId currentZoneId() {
        return TerminalContext.currentTimeZone().toZoneId();
    }

    @NotNull
    public static TimeZone currentTimeZone() {
        Context context = TerminalContext.get(false);
        return context.getTimeZone();
    }

    @NotNull
    public static Locale currentLocale() {
        Context context = TerminalContext.get(false);
        return context.getLocale();
    }

    public static Listener registerListener(String name, Listener listener) {
        return ContextListeners.put(name, listener);
    }

    public static Listener removeListener(String name) {
        return ContextListeners.remove(name);
    }

    @NotNull
    public static Context get() throws TerminalContextException {
        return TerminalContext.get(true);
    }

    @NotNull
    public static Context get(boolean onlyLogin) throws TerminalContextException {
        Context ctx = null;
        if (Active) {
            ctx = (Context)ContextLocal.get();
        }
        if (ctx == null) {
            ctx = Null;
        }
        if (onlyLogin && ctx.isNull()) {
            throw new TerminalContextException(AuthnErrorEnum.Unauthorized, "find null context, must be user or guest");
        }
        return ctx;
    }

    public static void login(@Nullable Context ctx) {
        if (ctx == null || ctx.isNull()) {
            TerminalContext.logout();
        } else {
            Active = true;
            ContextLocal.set((Object)ctx);
            TerminalContext.fireContextChange(false, ctx);
        }
    }

    @Nullable
    public static Context logout() {
        return TerminalContext.logout(true);
    }

    @Nullable
    public static Context logout(boolean fire) {
        Context old = (Context)ContextLocal.get();
        if (old != null) {
            ContextLocal.remove();
            if (fire) {
                TerminalContext.fireContextChange(true, old);
            }
        }
        return old;
    }

    private static void fireContextChange(boolean del, @NotNull Context ctx) {
        for (Listener listener : ContextListeners.values()) {
            try {
                listener.onChange(del, ctx);
            }
            catch (RuntimeException e) {
                DummyBlock.ignore((Throwable)e);
            }
        }
    }

    static {
        DefaultTimeZone = ThreadNow.sysTimeZone();
        DefaultLocale = Locale.getDefault();
    }

    public static class Context {
        private final long userId;
        private final Locale locale;
        private final TimeZone timeZone;
        private final Enum<?> authType;
        private final String username;
        private final Set<String> authPerm;
        private final Map<TypedKey<?>, Object> terminal;

        public Context(long userId, Locale locale, TimeZone timeZone, Map<TypedKey<?>, Object> params, Enum<?> authType, String username, Set<String> authPerm) {
            this.userId = userId;
            this.locale = locale != null ? locale : DefaultLocale;
            this.timeZone = timeZone != null ? timeZone : DefaultTimeZone;
            this.terminal = params != null ? params : Collections.emptyMap();
            this.authType = authType != null ? authType : pro.fessional.mirana.data.Null.Enm;
            this.username = username != null ? username : "";
            this.authPerm = authPerm != null ? authPerm : Collections.emptySet();
        }

        public boolean isNull() {
            return this.userId == Long.MIN_VALUE;
        }

        public boolean isGuest() {
            return this.userId == -1L;
        }

        public long getUserId() {
            return this.userId;
        }

        @NotNull
        public Locale getLocale() {
            return this.locale;
        }

        @NotNull
        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        @NotNull
        public ZoneId getZoneId() {
            return this.getTimeZone().toZoneId();
        }

        @NotNull
        public Enum<?> getAuthType() {
            return this.authType;
        }

        @NotNull
        public String getUsername() {
            return this.username;
        }

        @NotNull
        public Set<String> getAuthPerm() {
            return this.authPerm;
        }

        public boolean hasAuthPerm(String auth) {
            return this.authPerm.contains(auth);
        }

        public boolean anyAuthPerm(Collection<String> auths) {
            if (auths == null) {
                return false;
            }
            for (String auth : auths) {
                if (!this.authPerm.contains(auth)) continue;
                return true;
            }
            return false;
        }

        public boolean allAuthPerm(Collection<String> auths) {
            if (auths == null) {
                return true;
            }
            return this.authPerm.containsAll(auths);
        }

        @Nullable
        public <T> T getTerminal(@NotNull TypedKey<T> key) {
            return (T)key.get(this.terminal);
        }

        @Contract(value="_,true->!null")
        public <T> T getTerminal(@NotNull TypedKey<T> key, boolean notnull) {
            Object t = key.get(this.terminal);
            if (t == null && notnull) {
                throw new NullPointerException("Terminal Key " + String.valueOf(key) + " returned null");
            }
            return (T)t;
        }

        @Contract(value="_,!null->!null")
        public <T> T tryTerminal(@NotNull TypedKey<T> key, T elze) {
            return (T)key.tryOr(this.terminal, elze);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context context = (Context)o;
            return this.userId == context.userId && Objects.equals(this.locale, context.locale) && Objects.equals(this.timeZone, context.timeZone) && this.terminal.equals(context.terminal);
        }

        public int hashCode() {
            return Objects.hash(this.userId, this.locale, this.timeZone, this.terminal);
        }

        public String toString() {
            return "Context{userId=" + this.userId + ", locale=" + String.valueOf(this.locale) + ", timeZone=" + String.valueOf(this.timeZone) + ", authType=" + String.valueOf(this.authType) + ", username='" + this.username + "'}";
        }
    }

    public static interface Listener {
        public void onChange(boolean var1, @NotNull Context var2);
    }

    public static class Builder {
        private long userId;
        private Locale locale;
        private TimeZone timeZone;
        private Enum<?> authType;
        private String username;
        private final Set<String> authPerm;
        private final Map<TypedKey<?>, Object> terminal;

        public Builder() {
            this.userId = TerminalContext.Null.userId;
            this.authPerm = new HashSet<String>();
            this.terminal = new HashMap();
        }

        @Contract(value="_->this")
        public Builder locale(Locale lcl) {
            this.locale = lcl;
            return this;
        }

        @Contract(value="_->this")
        public Builder localeIfAbsent(Locale lcl) {
            if (this.locale == null) {
                this.locale = lcl;
            }
            return this;
        }

        @Contract(value="_->this")
        public Builder timeZone(TimeZone tz) {
            this.timeZone = tz;
            return this;
        }

        @Contract(value="_->this")
        public Builder timeZoneIfAbsent(TimeZone tz) {
            if (this.timeZone == null) {
                this.timeZone = tz;
            }
            return this;
        }

        @Contract(value="_->this")
        public Builder timeZone(ZoneId tz) {
            this.timeZone = TimeZone.getTimeZone(tz);
            return this;
        }

        @Contract(value="_->this")
        public Builder timeZoneIfAbsent(ZoneId tz) {
            if (this.timeZone == null) {
                this.timeZone = TimeZone.getTimeZone(tz);
            }
            return this;
        }

        @Contract(value="_->this")
        public Builder authType(Enum<?> at) {
            this.authType = at;
            return this;
        }

        @Contract(value="_->this")
        public Builder authTypeIfAbsent(Enum<?> at) {
            if (this.authType == null) {
                this.authType = at;
            }
            return this;
        }

        @Contract(value="_->this")
        public Builder username(String un) {
            this.username = un;
            return this;
        }

        @Contract(value="_->this")
        public Builder usernameIfAbsent(String un) {
            if (this.username == null) {
                this.username = un;
            }
            return this;
        }

        @Contract(value="_->this")
        public Builder authPerm(String pm) {
            this.authPerm.add(pm);
            return this;
        }

        @Contract(value="_->this")
        public Builder authPerm(Collection<String> pm) {
            this.authPerm.addAll(pm);
            return this;
        }

        @Contract(value="_,_->this")
        public <V> Builder terminal(TypedKey<V> key, V value) {
            this.terminal.put(key, value);
            return this;
        }

        @Contract(value="_,_->this")
        public <V> Builder terminalIfAbsent(TypedKey<V> key, V value) {
            this.terminal.putIfAbsent(key, value);
            return this;
        }

        @Contract(value="_->this")
        public Builder terminal(Map<TypedKey<?>, Object> kvs) {
            if (kvs != null) {
                this.terminal.putAll(kvs);
            }
            return this;
        }

        @Contract(value="_->this")
        public Builder terminalIfAbsent(Map<TypedKey<?>, Object> kvs) {
            if (kvs != null) {
                for (Map.Entry<TypedKey<?>, Object> en : kvs.entrySet()) {
                    this.terminal.putIfAbsent(en.getKey(), en.getValue());
                }
            }
            return this;
        }

        @Contract(value="_->this")
        public Builder user(long uid) {
            this.userId = uid;
            return this;
        }

        @Contract(value="_->this")
        public Builder userIfAbsent(Long uid) {
            if (this.userId == TerminalContext.Null.userId && uid != null) {
                this.userId = uid;
            }
            return this;
        }

        @Contract(value="_->this")
        public Builder userOrGuest(Long uid) {
            this.userId = uid == null ? -1L : uid;
            return this;
        }

        @Contract(value="->this")
        public Builder guest() {
            return this.user(-1L);
        }

        @NotNull
        public Context build() {
            if (this.userId == TerminalContext.Null.userId) {
                throw new IllegalArgumentException("invalid userid");
            }
            return new Context(this.userId, this.locale, this.timeZone, this.terminal, this.authType, this.username, this.authPerm);
        }
    }
}

