/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.fastjson;

import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.filter.ContextValueFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class FastJsonFilters {
    public static final ValueFilter NumberAsString = (object, name, value) -> {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        return value;
    };
    public static final ContextValueFilter NumberFormatString = (context, object, name, value) -> {
        String fmt;
        JSONField anno = (JSONField)context.getAnnotation(JSONField.class);
        if (anno != null && (fmt = anno.format()) != null && !fmt.isEmpty() && value instanceof Number) {
            DecimalFormat nf = new DecimalFormat(fmt);
            return nf.format(value);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        return value;
    };
}

