/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.fastjson;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import pro.fessional.wings.slardar.fastjson.FastJsonFilters;
import pro.fessional.wings.slardar.fastjson.FastJsonReaders;

public class FastJsonHelper {
    private static final ConcurrentHashMap<Object, Boolean> Inited = new ConcurrentHashMap();
    private static final EnumSet<JSONReader.Feature> ReaderEnum = EnumSet.of(JSONReader.Feature.SupportSmartMatch, JSONReader.Feature.UseNativeObject, JSONReader.Feature.IgnoreSetNullValue, JSONReader.Feature.ErrorOnNotSupportAutoType, JSONReader.Feature.AllowUnQuotedFieldNames);
    private static JSONReader.Feature[] ReaderCache = null;
    private static final EnumSet<JSONWriter.Feature> WriterEnum = EnumSet.of(JSONWriter.Feature.WriteEnumsUsingName, JSONWriter.Feature.WriteBigDecimalAsPlain, JSONWriter.Feature.WriteNonStringValueAsString, JSONWriter.Feature.BrowserCompatible);
    private static JSONWriter.Feature[] WriterCache = null;
    private static final LinkedHashMap<String, Filter> FilterList = new LinkedHashMap();
    private static Filter[] FilterCache;

    public static void initGlobal(boolean init) {
        ObjectReaderProvider readerProvider = JSONFactory.getDefaultObjectReaderProvider();
        if (init) {
            ObjectReader obj = readerProvider.registerIfAbsent(OffsetDateTime.class, FastJsonReaders.OffsetDateTimeReader);
            Inited.put(FastJsonReaders.OffsetDateTimeReader, obj == null);
        } else if (Inited.getOrDefault(FastJsonReaders.OffsetDateTimeReader, Boolean.FALSE).booleanValue()) {
            readerProvider.unregisterObjectReader(OffsetDateTime.class);
            Inited.remove(FastJsonReaders.OffsetDateTimeReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableFeature(@NotNull JSONReader.Feature f, boolean enable) {
        EnumSet<JSONReader.Feature> enumSet = ReaderEnum;
        synchronized (enumSet) {
            if (enable) {
                ReaderEnum.add(f);
            } else {
                ReaderEnum.remove(f);
            }
        }
        ReaderCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JSONReader.Feature[] DefaultReader() {
        if (ReaderCache == null) {
            EnumSet<JSONReader.Feature> enumSet = ReaderEnum;
            synchronized (enumSet) {
                ReaderCache = (JSONReader.Feature[])ReaderEnum.toArray(JSONReader.Feature[]::new);
            }
        }
        return ReaderCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableFeature(@NotNull JSONWriter.Feature f, boolean enable) {
        EnumSet<JSONWriter.Feature> enumSet = WriterEnum;
        synchronized (enumSet) {
            if (enable) {
                WriterEnum.add(f);
            } else {
                WriterEnum.remove(f);
            }
        }
        WriterCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JSONWriter.Feature[] DefaultWriter() {
        if (WriterCache == null) {
            EnumSet<JSONWriter.Feature> enumSet = WriterEnum;
            synchronized (enumSet) {
                WriterCache = (JSONWriter.Feature[])WriterEnum.toArray(JSONWriter.Feature[]::new);
            }
        }
        return WriterCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableFilter(@NotNull String name, @Nullable Filter filter) {
        LinkedHashMap<String, Filter> linkedHashMap = FilterList;
        synchronized (linkedHashMap) {
            if (filter == null) {
                FilterList.remove(name);
            } else {
                FilterList.put(name, filter);
            }
        }
        FilterCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Filter[] DefaultFilter() {
        if (FilterCache == null) {
            LinkedHashMap<String, Filter> linkedHashMap = FilterList;
            synchronized (linkedHashMap) {
                FilterCache = (Filter[])FilterList.values().toArray(Filter[]::new);
            }
        }
        return FilterCache;
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(@Nullable String json, @NotNull ResolvableType targetType) {
        if (json == null) {
            return null;
        }
        return (T)JSON.parseObject((String)json, (Type)targetType.getType(), (JSONReader.Feature[])FastJsonHelper.DefaultReader());
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(@Nullable String json, @NotNull TypeDescriptor targetType) {
        if (json == null) {
            return null;
        }
        return (T)JSON.parseObject((String)json, (Type)targetType.getResolvableType().getType(), (JSONReader.Feature[])FastJsonHelper.DefaultReader());
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(@Nullable String json, @NotNull TypeReference<T> targetType) {
        if (json == null) {
            return null;
        }
        return (T)JSON.parseObject((String)json, targetType, (JSONReader.Feature[])FastJsonHelper.DefaultReader());
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(@Nullable String json, @NotNull Type targetType) {
        if (json == null) {
            return null;
        }
        return (T)JSON.parseObject((String)json, (Type)targetType, (JSONReader.Feature[])FastJsonHelper.DefaultReader());
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(@Nullable String json, @NotNull Class<T> targetType) {
        if (json == null) {
            return null;
        }
        return (T)JSON.parseObject((String)json, targetType, (JSONReader.Feature[])FastJsonHelper.DefaultReader());
    }

    @Contract(value="!null->!null")
    public static String string(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        return JSON.toJSONString((Object)obj, (Filter[])FastJsonHelper.DefaultFilter(), (JSONWriter.Feature[])FastJsonHelper.DefaultWriter());
    }

    static {
        FilterList.put("NumberAsString", (Filter)FastJsonFilters.NumberAsString);
        FilterCache = null;
    }
}

