/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.httprest.okhttp;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.wings.slardar.httprest.okhttp.OkHttpInterceptor;

public class OkHttpRedirectNopInterceptor
implements OkHttpInterceptor {
    private static final Logger log = LoggerFactory.getLogger(OkHttpRedirectNopInterceptor.class);
    public static final String NopLocation = "Nop-Location";
    public static final String Location = "Location";

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        String loc;
        Request request = chain.request();
        Response response = chain.proceed(request);
        if (response.isRedirect() && request.header(NopLocation) != null && (loc = response.header(Location)) != null) {
            response = response.newBuilder().removeHeader(Location).addHeader(NopLocation, loc).build();
        }
        return response;
    }

    @Override
    public boolean isNetwork() {
        return true;
    }
}

