/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.httprest.okhttp;

import com.fasterxml.jackson.databind.JsonNode;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.wings.slardar.httprest.okhttp.OkHttpClientHelper;
import pro.fessional.wings.slardar.httprest.okhttp.OkHttpTokenClient;
import pro.fessional.wings.slardar.jackson.JacksonHelper;

public class OkHttpTokenizeLogin
implements OkHttpTokenClient.Tokenize {
    private static final Logger log = LoggerFactory.getLogger(OkHttpTokenizeLogin.class);
    private String keyUsername = "username";
    private String keyPassword = "password";
    private String keyToken;
    private String loginUrl;
    private String username;
    private String password;
    private String headerAuth;
    private boolean cookieAuto = false;
    private String headerAccept = "application/json";
    private String headerUserAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36";
    private transient String token;

    @Override
    public boolean needToken(@NotNull Request request) {
        if (this.cookieAuto) {
            return false;
        }
        String ah = request.header(this.headerAuth);
        return ah == null;
    }

    @Override
    public boolean fillToken(Request.Builder builder) {
        if (this.cookieAuto) {
            return true;
        }
        String tkn = this.token;
        if (tkn == null) {
            return false;
        }
        builder.header(this.headerAuth, tkn);
        return true;
    }

    @Override
    public boolean initToken(@NotNull Call.Factory callFactory) {
        FormBody.Builder builder = this.buildForm(new FormBody.Builder()).add(this.keyUsername, this.username).add(this.keyPassword, this.password);
        Request request = this.buildRequest(new Request.Builder()).header("Accept", this.headerAccept).header("User-Agent", this.headerUserAgent).url(this.loginUrl).post((RequestBody)builder.build()).build();
        Response res = OkHttpClientHelper.execute(callFactory, request, false);
        if (this.cookieAuto) {
            return true;
        }
        String tkn = this.parseResponse(res);
        if (tkn != null) {
            this.token = tkn;
        }
        return tkn != null;
    }

    @Contract(value="_->param1")
    protected FormBody.Builder buildForm(@NotNull FormBody.Builder builder) {
        return builder;
    }

    @Contract(value="_->param1")
    protected Request.Builder buildRequest(@NotNull Request.Builder builder) {
        return builder;
    }

    protected String parseResponse(@NotNull Response res) {
        String hd = res.header(this.headerAuth);
        if (hd != null) {
            return hd;
        }
        ResponseBody body = res.body();
        if (body == null) {
            return null;
        }
        return this.parseBody(body.string());
    }

    protected String parseBody(String str) {
        if (str == null) {
            return null;
        }
        if (this.headerAccept.contains("json") || this.headerAccept.contains("xml")) {
            JsonNode node = JacksonHelper.object(str);
            return JacksonHelper.getString(node, this.headerAuth, null);
        }
        return null;
    }

    public void setKeyUsername(String keyUsername) {
        this.keyUsername = keyUsername;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setKeyToken(String keyToken) {
        this.keyToken = keyToken;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHeaderAuth(String headerAuth) {
        this.headerAuth = headerAuth;
    }

    public void setCookieAuto(boolean cookieAuto) {
        this.cookieAuto = cookieAuto;
    }

    public void setHeaderAccept(String headerAccept) {
        this.headerAccept = headerAccept;
    }

    public void setHeaderUserAgent(String headerUserAgent) {
        this.headerUserAgent = headerUserAgent;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getKeyUsername() {
        return this.keyUsername;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeyToken() {
        return this.keyToken;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHeaderAuth() {
        return this.headerAuth;
    }

    public boolean isCookieAuto() {
        return this.cookieAuto;
    }

    public String getHeaderAccept() {
        return this.headerAccept;
    }

    public String getHeaderUserAgent() {
        return this.headerUserAgent;
    }

    public String getToken() {
        return this.token;
    }
}

