/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import pro.fessional.mirana.bits.Aes;
import pro.fessional.mirana.bits.Aes256;
import pro.fessional.wings.silencer.encrypt.Aes256Provider;
import pro.fessional.wings.slardar.jackson.AesString;

public class AesStringSerializer
extends JsonSerializer<String>
implements ContextualSerializer {
    private Aes aes;
    @NotNull
    private String mis = "*****";

    public void serialize(String value, JsonGenerator generator, SerializerProvider serializers) throws IOException {
        String str = this.aes == null ? this.mis : this.aes.encode64(value);
        generator.writeString(str);
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        AesString anno = (AesString)property.getAnnotation(AesString.class);
        if (anno == null) {
            return this;
        }
        AesString.Misfire mf = anno.misfire();
        Aes256 aes256 = Aes256Provider.get((String)anno.value(), (boolean)false);
        if (aes256 == null && mf == AesString.Misfire.Error) {
            throw new IllegalArgumentException("Aes key not found, name=" + anno.value());
        }
        AesStringSerializer ser = new AesStringSerializer();
        ser.aes = aes256;
        if (mf == AesString.Misfire.Masks) {
            ser.mis = "*****";
        } else if (mf == AesString.Misfire.Empty) {
            ser.mis = "";
        }
        return ser;
    }

    @Autowired
    public void setAes(Aes aes) {
        this.aes = aes;
    }
}

