/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.jackson;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import java.lang.reflect.Array;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.slardar.jackson.AutoRegisterPropertyFilter;

public class EmptyValuePropertyFilter
implements AutoRegisterPropertyFilter {
    private static final Logger log = LoggerFactory.getLogger(EmptyValuePropertyFilter.class);
    public static final String Id = "EmptyValue";
    private final LocalDate emptyDate;
    private final LocalDateTime emptyDateMin;
    private final LocalDateTime emptyDateMax;
    private final boolean emptyList;
    private final boolean emptyMap;

    public EmptyValuePropertyFilter(@Nullable LocalDate emptyDate, int offset, boolean list, boolean map) {
        this.emptyDate = emptyDate;
        if (emptyDate != null) {
            LocalDateTime dt = emptyDate.atStartOfDay();
            if (offset != 0) {
                this.emptyDateMin = dt.minusHours(offset);
                this.emptyDateMax = dt.plusHours(offset);
            } else {
                this.emptyDateMin = null;
                this.emptyDateMax = null;
            }
        } else {
            this.emptyDateMin = null;
            this.emptyDateMax = null;
        }
        this.emptyList = list;
        this.emptyMap = map;
    }

    @Override
    public String getId() {
        return Id;
    }

    @Override
    public void serializeAsField(Object pojo, JsonGenerator gen, SerializerProvider prov, PropertyWriter writer) throws Exception {
        block4: {
            JavaType rt = writer.getType();
            if (writer instanceof BeanPropertyWriter) {
                try {
                    BeanPropertyWriter wt = (BeanPropertyWriter)writer;
                    if (this.emptyDate != null && this.dealEmptyDate(pojo, gen, prov, wt, rt) || this.emptyList && this.dealEmptyList(pojo, gen, prov, wt, rt) || this.emptyMap && this.dealEmptyMap(pojo, gen, prov, wt, rt)) {
                        return;
                    }
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Skipping '" + String.valueOf(writer.getFullName()) + "' on '" + pojo.getClass().getName() + "' as an exception was thrown when retrieving its value", (Throwable)ex);
                }
            }
        }
        writer.serializeAsField(pojo, gen, prov);
    }

    private boolean dealEmptyList(Object pojo, JsonGenerator gen, SerializerProvider prov, BeanPropertyWriter writer, JavaType rt) throws Exception {
        Object v;
        boolean isArr = rt.isArrayType();
        if ((isArr || rt.isTypeOrSubTypeOf(Collection.class)) && ((v = writer.get(pojo)) instanceof Collection && ((Collection)v).isEmpty() || isArr && v != null && Array.getLength(v) == 0)) {
            return this.skipEmpty(pojo, gen, prov, writer);
        }
        return false;
    }

    private boolean dealEmptyMap(Object pojo, JsonGenerator gen, SerializerProvider prov, BeanPropertyWriter writer, JavaType rt) throws Exception {
        Object v;
        if (rt.isTypeOrSubTypeOf(Map.class) && (v = writer.get(pojo)) instanceof Map && ((Map)v).isEmpty()) {
            return this.skipEmpty(pojo, gen, prov, writer);
        }
        return false;
    }

    private boolean dealEmptyDate(Object pojo, JsonGenerator gen, SerializerProvider prov, BeanPropertyWriter writer, JavaType rt) throws Exception {
        Object v;
        if ((rt.isTypeOrSubTypeOf(LocalDate.class) || rt.isTypeOrSubTypeOf(LocalDateTime.class) || rt.isTypeOrSubTypeOf(ZonedDateTime.class) || rt.isTypeOrSubTypeOf(OffsetDateTime.class) || rt.isTypeOrSubTypeOf(Date.class)) && ((v = writer.get(pojo)) instanceof LocalDate && this.emptyDate((LocalDate)v) || v instanceof LocalDateTime && this.emptyDateTime((LocalDateTime)v) || v instanceof ZonedDateTime && this.emptyDateTime(((ZonedDateTime)v).toLocalDateTime()) || v instanceof OffsetDateTime && this.emptyDateTime(((OffsetDateTime)v).toLocalDateTime()) || v instanceof Date && this.emptyDateTime((Date)v))) {
            return this.skipEmpty(pojo, gen, prov, writer);
        }
        return false;
    }

    private boolean emptyDate(LocalDate d) {
        return this.emptyDate.equals(d);
    }

    private boolean emptyDateTime(Date dt) {
        LocalDateTime ldt = dt.toInstant().atZone(ThreadNow.sysZoneId()).toLocalDateTime();
        return this.emptyDateTime(ldt);
    }

    private boolean emptyDateTime(LocalDateTime dt) {
        if (this.emptyDate.equals(dt.toLocalDate())) {
            return true;
        }
        if (this.emptyDateMin == null || this.emptyDateMax == null) {
            return false;
        }
        return !dt.isBefore(this.emptyDateMin) && !dt.isAfter(this.emptyDateMax);
    }

    private boolean skipEmpty(Object pojo, JsonGenerator gen, SerializerProvider prov, BeanPropertyWriter writer) throws Exception {
        if (!gen.canOmitFields()) {
            writer.serializeAsOmittedField(pojo, gen, prov);
        }
        return true;
    }

    @JsonFilter(value="EmptyValue")
    public static class EmptyDateMixin {
    }
}

