/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.jackson;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.util.StringUtils;
import pro.fessional.mirana.data.R;
import pro.fessional.wings.slardar.context.LocaleZoneIdUtil;
import pro.fessional.wings.slardar.jackson.AutoRegisterPropertyFilter;

public class I18nResultPropertyFilter
implements AutoRegisterPropertyFilter {
    private static final Logger log = LoggerFactory.getLogger(I18nResultPropertyFilter.class);
    public static final String Id = "I18nResult";
    private final MessageSource messageSource;

    @Override
    public String getId() {
        return Id;
    }

    @Override
    public void serializeAsField(Object pojo, JsonGenerator gen, SerializerProvider prov, PropertyWriter writer) throws Exception {
        if ("message".equals(writer.getName())) {
            try {
                R value = (R)pojo;
                String i18nCode = value.getI18nCode();
                if (StringUtils.hasText((String)i18nCode)) {
                    Locale locale = LocaleZoneIdUtil.LocaleNonnull.get();
                    String i18n = this.messageSource.getMessage(i18nCode, value.getI18nArgs(), locale);
                    if (StringUtils.hasText((String)i18n) && !i18n.equalsIgnoreCase(i18nCode)) {
                        value.setMessage(i18n);
                    }
                }
            }
            catch (Exception ex) {
                log.warn("failed to trans i18n code to message", (Throwable)ex);
            }
        }
        writer.serializeAsField(pojo, gen, prov);
    }

    public I18nResultPropertyFilter(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @JsonFilter(value="I18nResult")
    public static class I18nResultMixin {
    }
}

