/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.jackson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import pro.fessional.mirana.cast.BoxedCastUtil;

public class StringMapGenerator
extends JsonGenerator {
    private int featureMask = 0;
    private ObjectCodec objectCodec = null;
    private final EnumMap<JsonGenerator.Feature, Boolean> features = new EnumMap(JsonGenerator.Feature.class);
    private final Map<String, String> resultTree;
    private String currentKey;

    public static StringMapGenerator treeMap() {
        return new StringMapGenerator(new TreeMap<String, String>());
    }

    public static StringMapGenerator linkMap() {
        return new StringMapGenerator(new LinkedHashMap<String, String>());
    }

    public static StringMapGenerator hashMap() {
        return new StringMapGenerator(new HashMap<String, String>());
    }

    public static StringMapGenerator userMap(Map<String, String> map) {
        return new StringMapGenerator(map);
    }

    private StringMapGenerator(Map<String, String> map) {
        this.resultTree = map;
    }

    public Map<String, String> getResultTree() {
        return this.resultTree;
    }

    private void putStringValue(String text) {
        this.resultTree.put(this.currentKey, text);
    }

    public JsonGenerator setCodec(ObjectCodec oc) {
        this.objectCodec = oc;
        return this;
    }

    public ObjectCodec getCodec() {
        return this.objectCodec;
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public JsonGenerator enable(JsonGenerator.Feature f) {
        this.features.put(f, true);
        return this;
    }

    public JsonGenerator disable(JsonGenerator.Feature f) {
        this.features.remove(f);
        return this;
    }

    public boolean isEnabled(JsonGenerator.Feature f) {
        return BoxedCastUtil.orFalse((Boolean)this.features.get(f));
    }

    public int getFeatureMask() {
        return this.featureMask;
    }

    @Deprecated
    public JsonGenerator setFeatureMask(int values) {
        this.featureMask = values;
        return this;
    }

    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    public void writeStartArray() {
    }

    public void writeEndArray() {
    }

    public void writeStartObject() {
    }

    public void writeEndObject() {
    }

    public void writeFieldName(String name) {
        this.currentKey = name;
    }

    public void writeFieldName(SerializableString name) {
        this.writeFieldName(name.getValue());
    }

    public void writeString(String text) {
        this.putStringValue(text);
    }

    public void writeString(char[] text, int offset, int len) {
        this.putStringValue(new String(text, offset, len));
    }

    public void writeString(SerializableString text) {
        this.putStringValue(text.getValue());
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) {
        this.putStringValue(new String(text, offset, length, StandardCharsets.UTF_8));
    }

    public void writeUTF8String(byte[] text, int offset, int length) {
        this.putStringValue(new String(text, offset, length, StandardCharsets.UTF_8));
    }

    public void writeRaw(String text) {
        this.putStringValue(text);
    }

    public void writeRaw(String text, int offset, int len) {
        this.putStringValue(text.substring(offset, len));
    }

    public void writeRaw(char[] text, int offset, int len) {
        this.putStringValue(new String(text, offset, len));
    }

    public void writeRaw(char c) {
        this.putStringValue(String.valueOf(c));
    }

    public void writeRawValue(String text) {
        this.putStringValue(text);
    }

    public void writeRawValue(String text, int offset, int len) {
        this.putStringValue(text.substring(offset, len));
    }

    public void writeRawValue(char[] text, int offset, int len) {
        this.putStringValue(new String(text, offset, len));
    }

    public void writeBinary(Base64Variant bv, byte[] data, int offset, int len) {
    }

    public int writeBinary(Base64Variant bv, InputStream data, int dataLength) {
        return 0;
    }

    public void writeNumber(int v) {
        this.putStringValue(String.valueOf(v));
    }

    public void writeNumber(long v) {
        this.putStringValue(String.valueOf(v));
    }

    public void writeNumber(BigInteger v) {
        this.putStringValue(String.valueOf(v));
    }

    public void writeNumber(double v) {
        this.putStringValue(String.valueOf(v));
    }

    public void writeNumber(float v) {
        this.putStringValue(String.valueOf(v));
    }

    public void writeNumber(BigDecimal v) {
        this.putStringValue(String.valueOf(v));
    }

    public void writeNumber(String encodedValue) {
        this.putStringValue(encodedValue);
    }

    public void writeBoolean(boolean state) {
        this.putStringValue(String.valueOf(state));
    }

    public void writeNull() {
        this.putStringValue(null);
    }

    public void writeObject(Object pojo) {
    }

    public void writeTree(TreeNode node) {
    }

    public JsonStreamContext getOutputContext() {
        return null;
    }

    public void flush() {
    }

    public boolean isClosed() {
        return false;
    }

    public void close() {
    }
}

