/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.IOException;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import pro.fessional.wings.silencer.jaxb.StringMapXmlWriter;
import pro.fessional.wings.slardar.jackson.StringMapGenerator;

public class StringMapHelper {
    public static Map<String, String> treeJson(Object object, ObjectMapper mapper) throws IOException {
        StringMapGenerator generator = StringMapGenerator.treeMap();
        mapper.writeValue((JsonGenerator)generator, object);
        return generator.getResultTree();
    }

    public static Map<String, String> linkJson(Object object, ObjectMapper mapper) throws IOException {
        StringMapGenerator generator = StringMapGenerator.linkMap();
        mapper.writeValue((JsonGenerator)generator, object);
        return generator.getResultTree();
    }

    public static Map<String, String> treeJaxb(Object object) throws JAXBException {
        JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        Marshaller marshaller = contextObj.createMarshaller();
        StringMapXmlWriter writer = StringMapXmlWriter.treeMap();
        marshaller.marshal(object, (XMLStreamWriter)writer);
        return writer.getResultTree();
    }

    public static Map<String, String> linkJaxb(Object object) throws JAXBException {
        JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        Marshaller marshaller = contextObj.createMarshaller();
        StringMapXmlWriter writer = StringMapXmlWriter.linkMap();
        marshaller.marshal(object, (XMLStreamWriter)writer);
        return writer.getResultTree();
    }

    public static Map<String, String> json(Object object, ObjectMapper mapper) {
        try {
            return StringMapHelper.treeJson(object, mapper);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Map<String, String> jaxb(Object object) {
        try {
            return StringMapHelper.treeJaxb(object);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }
}

