/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.monitor;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import pro.fessional.wings.silencer.spring.help.ApplicationContextHelper;
import pro.fessional.wings.slardar.context.Now;
import pro.fessional.wings.slardar.monitor.WarnFilter;
import pro.fessional.wings.slardar.monitor.WarnMetric;
import pro.fessional.wings.slardar.monitor.WarnReport;

public class MonitorTask
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MonitorTask.class);
    private List<WarnMetric> warnMetrics = Collections.emptyList();
    private List<WarnReport> warnReports = Collections.emptyList();
    private List<WarnFilter> warnFilters = Collections.emptyList();
    private String applicationName = null;
    private boolean hookSelf = true;

    @Scheduled(cron="${wings.slardar.monitor.cron}")
    public void run() {
        log.info("MonitorTask started");
        LinkedHashMap<String, List<WarnMetric.Warn>> warns = new LinkedHashMap<String, List<WarnMetric.Warn>>();
        this.metric(warns);
        this.filter(warns);
        this.report(warns);
    }

    public void metric(Map<String, List<WarnMetric.Warn>> warns) {
        for (WarnMetric metric : this.warnMetrics) {
            String nm = metric.getKey();
            try {
                List<WarnMetric.Warn> wn = metric.check();
                int sz = wn.size();
                if (sz > 0) {
                    warns.put(nm, wn);
                }
                log.debug("check {} warns by {}", (Object)sz, (Object)nm);
            }
            catch (Exception e) {
                log.warn("failed to metric, name=" + nm, (Throwable)e);
            }
        }
    }

    private void filter(Map<String, List<WarnMetric.Warn>> warns) {
        for (WarnFilter filter : this.warnFilters) {
            filter.filter(warns);
        }
    }

    public void report(Map<String, List<WarnMetric.Warn>> warns) {
        String jvm;
        String app;
        if (this.warnReports.isEmpty()) {
            return;
        }
        String string = app = this.applicationName != null ? this.applicationName : ApplicationContextHelper.getApplicationName();
        if (app.isBlank()) {
            log.warn("the app name of report should NOT blank");
        }
        if ((jvm = ManagementFactory.getRuntimeMXBean().getName()) != null) {
            jvm = jvm.replace("@", "_");
        }
        for (WarnReport report : this.warnReports) {
            String rpt = report.getClass().getName();
            try {
                log.debug("check {} warns by {}", (Object)warns.size(), (Object)rpt);
                WarnReport.Sts sts = report.report(app, jvm, warns);
                if (sts == WarnReport.Sts.Fail) {
                    log.warn("failed to report={}", (Object)rpt);
                    continue;
                }
                log.info("report={}, status={}", (Object)rpt, (Object)sts);
            }
            catch (Exception e) {
                log.warn("failed to report, name=" + rpt, (Throwable)e);
            }
        }
    }

    public void afterPropertiesSet() {
        if (this.hookSelf) {
            this.reportHook("started");
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.reportHook("shutting")));
        }
    }

    private void reportHook(String key) {
        try {
            WarnMetric.Warn wn = new WarnMetric.Warn();
            wn.setType(WarnMetric.Type.Text);
            wn.setKey(key);
            wn.setRule("time");
            wn.setWarn(Now.zonedDateTime().toString());
            List<WarnMetric.Warn> ws = Collections.singletonList(wn);
            Map<String, List<WarnMetric.Warn>> warns = Collections.singletonMap("wings.slardar.monitor.hook", ws);
            this.report(warns);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setHookSelf(boolean hookSelf) {
        this.hookSelf = hookSelf;
    }

    public List<WarnMetric> getWarnMetrics() {
        return this.warnMetrics;
    }

    public List<WarnReport> getWarnReports() {
        return this.warnReports;
    }

    public List<WarnFilter> getWarnFilters() {
        return this.warnFilters;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public boolean isHookSelf() {
        return this.hookSelf;
    }

    @Autowired
    public void setWarnMetrics(List<WarnMetric> warnMetrics) {
        this.warnMetrics = warnMetrics;
    }

    @Autowired
    public void setWarnReports(List<WarnReport> warnReports) {
        this.warnReports = warnReports;
    }

    @Autowired(required=false)
    public void setWarnFilters(List<WarnFilter> warnFilters) {
        this.warnFilters = warnFilters;
    }
}

