/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.serialize;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.DefaultInstantiatorStrategy;
import org.jetbrains.annotations.NotNull;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import pro.fessional.mirana.evil.ThreadLocalAttention;
import pro.fessional.mirana.evil.ThreadLocalSoft;
import pro.fessional.wings.slardar.serialize.javakaffee.SynchronizedCollectionsSerializer;
import pro.fessional.wings.slardar.serialize.javakaffee.UnmodifiableCollectionsSerializer;

public class KryoSimple {
    private static final ThreadLocalSoft<Output> output;
    private static final ThreadLocalSoft<Kryo> kryo;

    public static void register(Kryo kryo) {
        UnmodifiableCollectionsSerializer.registerSerializers(kryo);
        SynchronizedCollectionsSerializer.registerSerializers(kryo);
    }

    public static Kryo getKryo() {
        return (Kryo)kryo.use();
    }

    public static Output getOutput() {
        Output out = (Output)output.use();
        out.reset();
        return out;
    }

    public static <T> T readClassAndObject(byte[] bytes) {
        Input input = new Input(bytes);
        return KryoSimple.readClassAndObject(input);
    }

    public static <T> T readClassAndObject(Input input) {
        return (T)((Kryo)kryo.use()).readClassAndObject(input);
    }

    public static <T> T readObject(Input input, Class<T> clz) {
        return (T)((Kryo)kryo.use()).readObject(input, clz);
    }

    public static <T> T readObjectOrNull(Input input, Class<T> clz) {
        return (T)((Kryo)kryo.use()).readObjectOrNull(input, clz);
    }

    public static byte[] writeClassAndObject(Object obj) {
        Output out = KryoSimple.getOutput();
        ((Kryo)kryo.use()).writeClassAndObject(out, obj);
        out.flush();
        return out.toBytes();
    }

    public static void writeClassAndObject(Output out, Object obj) {
        ((Kryo)kryo.use()).writeClassAndObject(out, obj);
    }

    public static void writeObject(Output out, Object obj) {
        ((Kryo)kryo.use()).writeObject(out, obj);
    }

    public static void writeObjectOrNull(Output out, Object obj, Class<?> clz) {
        ((Kryo)kryo.use()).writeObjectOrNull(out, obj, clz);
    }

    static {
        try {
            output = new ThreadLocalSoft<Output>(new ThreadLocal()){

                @NotNull
                public Output initValue() {
                    return new Output(4096, 0x100000);
                }
            };
        }
        catch (ThreadLocalAttention e) {
            throw new IllegalStateException(e);
        }
        try {
            kryo = new ThreadLocalSoft<Kryo>(new ThreadLocal()){

                @NotNull
                public Kryo initValue() {
                    Kryo ko = new Kryo();
                    ko.setReferences(false);
                    ko.setRegistrationRequired(false);
                    ko.setInstantiatorStrategy((InstantiatorStrategy)new DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
                    ko.setClassLoader(Thread.currentThread().getContextClassLoader());
                    KryoSimple.register(ko);
                    return ko;
                }
            };
        }
        catch (ThreadLocalAttention e) {
            throw new IllegalStateException(e);
        }
    }
}

