/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cache2k.extra.spring.SpringCache2kCacheManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.AbstractCachingConfiguration;
import org.springframework.cache.annotation.CachingConfigurer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.AbstractCacheResolver;
import org.springframework.cache.interceptor.CacheInterceptor;
import org.springframework.cache.interceptor.CacheOperationSource;
import org.springframework.cache.interceptor.SimpleCacheResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.cache.WingsCacheHelper;
import pro.fessional.wings.slardar.cache.cache2k.WingsCache2k;
import pro.fessional.wings.slardar.cache.cache2k.WingsCache2kManager;
import pro.fessional.wings.slardar.cache.spring.CacheEvictMultiKeys;
import pro.fessional.wings.slardar.cache.spring.WingsCacheAnnoOprSource;
import pro.fessional.wings.slardar.cache.spring.WingsCacheInterceptor;
import pro.fessional.wings.slardar.cache.spring.WingsCacheResolver;
import pro.fessional.wings.slardar.spring.prop.SlardarCacheProp;

@EnableCaching
@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class SlardarCacheConfiguration {
    private static final Log log = LogFactory.getLog(SlardarCacheConfiguration.class);

    public SlardarCacheConfiguration(@Value(value="${spring.jmx.enabled:false}") boolean jmx) {
        log.info((Object)("Slardar spring.jmx.enabled=" + jmx + ", if can NOT disable, check IDEA 'Disable JMX agent' options"));
        if (!jmx && WingsCache2k.FeatureJmx != null) {
            log.info((Object)"Slardar cache2k FeatureJmx but spring.jmx.enabled=false");
            WingsCache2k.FeatureJmx = null;
        }
    }

    @Bean(value={"MemoryCacheManager"})
    @ConditionalWingsEnabled
    public SpringCache2kCacheManager cache2kCacheManager(SlardarCacheProp conf) {
        log.info((Object)"Slardar spring-bean cache2kCacheManager as MemoryCacheManager");
        return new WingsCache2kManager("spring-wings-" + this.hashCode(), conf);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled
    public static class CacheMgr
    implements CachingConfigurer {
        private final ConfigurableListableBeanFactory beanFactory;

        @Bean
        @Primary
        public CacheManager cacheManager() {
            Map managers = this.beanFactory.getBeansOfType(CacheManager.class);
            Map resolvers = this.beanFactory.getBeansOfType(AbstractCacheResolver.class);
            SlardarCacheProp cacheProp = (SlardarCacheProp)this.beanFactory.getBean(SlardarCacheProp.class);
            HashMap<String, CacheManager> managerMap = new HashMap<String, CacheManager>(managers);
            for (Map.Entry en : resolvers.entrySet()) {
                log.info((Object)("Slardar find CacheManager via resolvers, name=" + (String)en.getKey()));
                managerMap.put((String)en.getKey(), ((AbstractCacheResolver)en.getValue()).getCacheManager());
            }
            for (Map.Entry en : managers.entrySet()) {
                String key = (String)en.getKey() + "Resolver";
                CacheManager cm = (CacheManager)en.getValue();
                managerMap.put(key, cm);
                if (this.beanFactory.containsBean(key)) {
                    log.debug((Object)("Slardar skip register cacheResolver bean=" + key + ", for existed"));
                    continue;
                }
                boolean exp = cacheProp.isExpand();
                WingsCacheResolver resolver = exp ? new WingsCacheResolver(cm) : new SimpleCacheResolver(cm);
                this.beanFactory.registerSingleton(key, (Object)resolver);
                log.info((Object)("Slardar spring-bean register dynamic cacheResolver bean=" + key + ", expand=" + exp));
            }
            WingsCacheHelper.putManagers(managerMap);
            CacheManager pre = null;
            String cnm = null;
            String prim = cacheProp.getPrimary();
            for (Map.Entry en : managers.entrySet()) {
                String name = (String)en.getKey();
                log.info((Object)("Slardar spring-bean cacheManager name=" + name));
                if (name.equalsIgnoreCase(prim)) {
                    log.info((Object)("Slardar spring-bean cacheManager Primary=" + name));
                    return (CacheManager)en.getValue();
                }
                if (pre != null || !name.startsWith(prim)) continue;
                cnm = name;
                pre = (CacheManager)en.getValue();
            }
            log.info((Object)("Slardar spring-bean cacheManager Primary=" + cnm));
            return pre;
        }

        public CacheMgr(ConfigurableListableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled
    public static class CacheAop
    extends AbstractCachingConfiguration {
        @Bean
        @Primary
        public CacheOperationSource wingsCacheOperationSource() {
            log.info((Object)"Slardar spring-bean wingsCacheOperationSource as Primary");
            return new WingsCacheAnnoOprSource();
        }

        @Bean
        @Primary
        public CacheInterceptor wingsCacheInterceptor(CacheOperationSource cacheOperationSource) {
            log.info((Object)"Slardar spring-bean wingsCacheInterceptor as Primary");
            CacheEvictMultiKeys.wingsSupport = true;
            WingsCacheInterceptor interceptor = new WingsCacheInterceptor();
            interceptor.configure(this.errorHandler, this.keyGenerator, this.cacheResolver, this.cacheManager);
            interceptor.setCacheOperationSource(cacheOperationSource);
            return interceptor;
        }
    }
}

