/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.async;

import java.time.Instant;
import java.util.concurrent.ScheduledFuture;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import pro.fessional.mirana.time.ThreadNow;

public class TaskSchedulerHelper {
    protected static ThreadPoolTaskScheduler LightTasker;
    protected static ThreadPoolTaskScheduler HeavyTasker;

    protected TaskSchedulerHelper(ThreadPoolTaskScheduler light, ThreadPoolTaskScheduler heavy) {
        LightTasker = light;
        HeavyTasker = heavy;
    }

    @Contract(value="true->!null")
    public static ThreadPoolTaskScheduler Light(boolean nonnull) {
        if (nonnull && LightTasker == null) {
            throw new IllegalStateException("LightTasker must init before using");
        }
        return LightTasker;
    }

    @Contract(value="true->!null")
    public static ThreadPoolTaskScheduler Heavy(boolean nonnull) {
        if (nonnull && HeavyTasker == null) {
            throw new IllegalStateException("HeavyTasker must init before using");
        }
        return HeavyTasker;
    }

    @NotNull
    public static ThreadPoolTaskScheduler referScheduler(boolean fast) {
        return fast ? TaskSchedulerHelper.Light(true) : TaskSchedulerHelper.Heavy(true);
    }

    public static void execute(boolean fast, @NotNull Runnable task) {
        TaskSchedulerHelper.referScheduler(fast).execute(task);
    }

    public static ScheduledFuture<?> execute(boolean fast, long delayMs, @NotNull Runnable task) {
        return TaskSchedulerHelper.referScheduler(fast).schedule(task, Instant.ofEpochMilli(ThreadNow.millis() + delayMs));
    }

    public static ScheduledFuture<?> execute(boolean fast, Instant start, @NotNull Runnable task) {
        return TaskSchedulerHelper.referScheduler(fast).schedule(task, start);
    }

    public static ScheduledFuture<?> execute(boolean fast, Trigger trigger, @NotNull Runnable task) {
        return TaskSchedulerHelper.referScheduler(fast).schedule(task, trigger);
    }
}

